-- ----------------------------
-- APP接口请求日志
-- ----------------------------
DROP TABLE IF EXISTS `app_api_log`;
CREATE TABLE `app_api_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `userid` int(11) COMMENT '用户',
  `phone` varchar(11) COMMENT '手机号码',
  `operation` varchar(50) COMMENT '用户操作',
  `method` varchar(200) COMMENT '请求方法',
  `params` text COMMENT '请求参数',
  `time` bigint NOT NULL COMMENT '执行时长(毫秒)',
  `ip` varchar(64) COMMENT 'IP地址',
  `create_date` datetime COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `app_api_log_phone` (`phone`) USING BTREE
) ENGINE=`InnoDB` DEFAULT CHARACTER SET utf8mb4 COMMENT='API日志';

-- ----------------------------
-- APP用户
-- 认证情况说明：0为未认证；1为审核中；2为已通过；3为不通过,排序为：1企业认证；2接单人认证；3发布车位用户认证；4发布汽车用户认证；5租车用户认证；6人共享认证；其他为扩展位
-- 如值为：2010000000 表示该用户企业认证已通过，车位用户认证审核中，其他认证为未认证
-- ----------------------------
DROP TABLE IF EXISTS `app_user`;

CREATE TABLE `app_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
   `super_id` int(11) DEFAULT NULL COMMENT '上级ID',
  `phone` varchar(11) DEFAULT NULL COMMENT '手机号码',
  `thirdid` varchar(64) DEFAULT NULL COMMENT '第三方ID',
  `clientid` varchar(64) DEFAULT NULL COMMENT '客户ID',
  `password` varchar(100) DEFAULT NULL COMMENT '密码',
  `nickname` varchar(50) DEFAULT NULL COMMENT '昵称',
  `head_img_url` text DEFAULT NULL COMMENT '头像',
  `certify` varchar(10) DEFAULT '0000000000' COMMENT '认证情况[暂不启用]',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1正常;2禁用]',
  `balance` decimal(10,2) DEFAULT '0' COMMENT '余额',
  `deposit` decimal(10,2) DEFAULT '0' COMMENT '保障金',
  `frozen_deposit` decimal(10,2) DEFAULT '0' COMMENT '冻结保障金',
  `stop_accept` tinyint(2) DEFAULT '1' COMMENT '停止任务接收[1:正常2:停止]',
  `last_login_time` datetime DEFAULT NULL COMMENT '最后登录时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `app_user_phone` (`phone`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='APP用户';

-- ----------------------------
-- APP用户扩展信息
-- ----------------------------
DROP TABLE IF EXISTS `app_user_ext`;

CREATE TABLE `app_user_ext` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `userid` int(11) NOT NULL COMMENT '用户id',
  `aftersale_total_praise` int(11) NOT NULL DEFAULT '0' COMMENT '共享售后总评价分',
  `aftersale_praise` decimal(5,2) NOT NULL DEFAULT '5.00' COMMENT '共享售后评价分',
  `aftersale_total_rate` int(11) NOT NULL DEFAULT '0' COMMENT '共享售后总完成率',
  `aftersale_rate` decimal(5,2) NOT NULL DEFAULT '5.00' COMMENT '共享售后完成率',
  `business_total_praise` int(11) NOT NULL DEFAULT '0' COMMENT '共享业总评价分',
  `business_praise` decimal(5,2) NOT NULL DEFAULT '5.00' COMMENT '共享业评价分',
  `business_total_rate` int(11) NOT NULL DEFAULT '0' COMMENT '共享业总完成率',
  `business_rate` decimal(5,2) NOT NULL DEFAULT '5.00' COMMENT '共享业完成率',
  `timing_total_praise` int(11) NOT NULL DEFAULT '0' COMMENT '共享计时总评价分',
  `timing_praise` decimal(5,2) NOT NULL DEFAULT '5.00' COMMENT '共享计时评价分',
  `timing_total_rate` int(11) NOT NULL DEFAULT '0' COMMENT '共享计时总完成率',
  `timing_rate` decimal(5,2) NOT NULL DEFAULT '5.00' COMMENT '共享计时完成率',
  `piece_total_praise` int(11) NOT NULL DEFAULT '0' COMMENT '共享计件总评价分',
  `piece_praise` decimal(5,2) NOT NULL DEFAULT '5.00' COMMENT '共享计件评价分',
  `piece_total_rate` int(11) NOT NULL DEFAULT '0' COMMENT '共享计件总完成率',
  `piece_rate` decimal(5,2) NOT NULL DEFAULT '5.00' COMMENT '共享计件完成率',
  `update_time` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `app_user_ext_userid` (`userid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='APP用户扩展信息';

-- ----------------------------
-- APP用户认证信息==认证情况
-- ----------------------------
DROP TABLE IF EXISTS `app_user_auth`;

CREATE TABLE `app_user_auth` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `after_auth_business` tinyint(2) DEFAULT '0' COMMENT '售后认证-商家认证 0:未认证;1:审核中;2:已通过;3:已拒绝',
  `after_auth_orderer` tinyint(2) DEFAULT '0' COMMENT '售后认证-接单人认证 0:未认证;1:审核中;2:已通过;3:已拒绝',
  `basic_auth_business` tinyint(2) DEFAULT '0' COMMENT '基础认证-商家认证 0:未认证;1:审核中;2:已通过;3:已拒绝',
  `basic_auth_personal` tinyint(2) DEFAULT '0' COMMENT '基础认证-个人认证 0:未认证;1:审核中;2:已通过;3:已拒绝',
  `business_auth_business` tinyint(2) DEFAULT '0' COMMENT '业务认证-商家认证 0:未认证;1:审核中;2:已通过;3:已拒绝',
  `business_auth_orderer` tinyint(2) DEFAULT '0' COMMENT '业务认证-接单人认证 0:未认证;1:审核中;2:已通过;3:已拒绝',
	`car_auth_orderer` tinyint(2) DEFAULT '0' COMMENT '租车认证 0:未认证;1:审核中;2:已通过;3:已拒绝',
	`car_auth_owner` tinyint(2) DEFAULT '0' COMMENT '发布租车认证 0:未认证;1:审核中;2:已通过;3:已拒绝',
	`filter_auth_owner` tinyint(2) DEFAULT '0' COMMENT '净化器认证 0:未认证;1:审核中;2:已通过;3:已拒绝',
	`filter_auth_orderer` tinyint(2) DEFAULT '0' COMMENT '净化器租用认证 0:未认证;1:审核中;2:已通过;3:已拒绝',
	`parking_auth_owner` tinyint(2) DEFAULT '0' COMMENT '发布车位认证 0:未认证;1:审核中;2:已通过;3:已拒绝',
	`parking_auth_orderer` tinyint(2) DEFAULT '0' COMMENT '车位租用认证 0:未认证;1:审核中;2:已通过;3:已拒绝',
	`piece_auth_business` tinyint(2) DEFAULT '0' COMMENT '计件工认证-商家认证 0:未认证;1:审核中;2:已通过;3:已拒绝',
	`piece_auth_orderer` tinyint(2) DEFAULT '0' COMMENT '计件工认证-接单人认证 0:未认证;1:审核中;2:已通过;3:已拒绝',
	`timing_auth_business` tinyint(2) DEFAULT '0' COMMENT '计时工认证-商家认证 0:未认证;1:审核中;2:已通过;3:已拒绝',
	`timing_auth_orderer` tinyint(2) DEFAULT '0' COMMENT '计时工认证-接单人认证 0:未认证;1:审核中;2:已通过;3:已拒绝',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `app_user_auth_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='APP用户认证信息';

-- ----------------------------
-- APP用户认证信息==企业认证
-- ----------------------------
DROP TABLE IF EXISTS `app_user_auth_bs`;

CREATE TABLE `app_user_auth_bs` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `business_name` varchar(50) DEFAULT NULL COMMENT '公司名称',
  `register_no` varchar(50) DEFAULT NULL COMMENT '注册号',
  `legal_name` varchar(20) DEFAULT NULL COMMENT '法定代表人',
  `idcard_type` tinyint(2) DEFAULT NULL COMMENT '证件类型 1身份证2其他',
  `idcard_no` varchar(50) DEFAULT NULL COMMENT '证件号码',
  `idcard_indate` date DEFAULT NULL COMMENT '证件有效期',
  `idcard_img` varchar(255) DEFAULT NULL COMMENT '身份证电子版',
  `register_addr` varchar(255) DEFAULT NULL COMMENT '公司注册地',
  `business_term` varchar(10) DEFAULT NULL COMMENT '营业期限',
  `registered_capital` varchar(10) DEFAULT NULL COMMENT '注册资本',
  `business_img` varchar(255) DEFAULT NULL COMMENT '公司营业执照',
  `status` tinyint(2) DEFAULT '0' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `address` varchar(55) DEFAULT NULL COMMENT '公司详细地址',
  `contact` varchar(20) DEFAULT NULL COMMENT '联系人',
  `contact_tel` varchar(30) DEFAULT NULL COMMENT '联系电话',
  `audit_time` datetime DEFAULT null COMMENT '审核时间',
  `update_time` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `app_user_auth_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='APP用户认证信息-企业';

-- ----------------------------
-- APP用户认证信息==接单人
-- ----------------------------
DROP TABLE IF EXISTS `app_user_auth_sp`;

CREATE TABLE `app_user_auth_sp` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真是姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
  `sex` tinyint(2) DEFAULT '1' COMMENT '性别[1男;2女]',
  `major` varchar(55) DEFAULT NULL COMMENT '专业',
  `service_area_province` varchar(55) DEFAULT NULL COMMENT '服务区域省',
  `service_area_city` varchar(55) DEFAULT NULL COMMENT '服务区域市',
  `service_area_details` varchar(255) DEFAULT NULL COMMENT '服务区域详情地址',
  `holding_id_card` varchar(255) DEFAULT NULL COMMENT '手持身份证',
  `default_harvest_address` varchar(255) DEFAULT NULL COMMENT '默认收获地址',
  `contacts` varchar(10) DEFAULT NULL COMMENT '联系人',
  `contact_number` varchar(30) DEFAULT NULL COMMENT '联系电话',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT null COMMENT '审核时间',
  `update_time` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `app_user_auth_sp_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='APP用户认证信息-接单人';


-- ----------------------------
-- APP用户认证信息==人共享
-- ----------------------------
DROP TABLE IF EXISTS `app_user_auth_ps`;

CREATE TABLE `app_user_auth_ps` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真是姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
  `front_of_idcard` varchar(255) DEFAULT NULL COMMENT '身份证正面',
  `reverse_of_idcard` varchar(255) DEFAULT NULL COMMENT '身份证反面',
  `face_recognition` varchar(255) DEFAULT NULL COMMENT '人脸识别',
  `detailed_address` varchar(255) DEFAULT NULL COMMENT '详细地址',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `app_user_auth_ps_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='APP用户认证信息-人共享';

-- ----------------------------
-- 意见反馈
-- ----------------------------
DROP TABLE IF EXISTS `feed_back`;

CREATE TABLE `feed_back` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `feed_back_user_id` int(11) DEFAULT NULL COMMENT '反馈人ID（登录后）',
  `phone` varchar(20) DEFAULT NULL COMMENT '反馈人手机号码（登录后）',
  `nickname` varchar(50) DEFAULT NULL COMMENT '昵称（登录后）',
  `feed_back_phone` varchar(11) DEFAULT NULL COMMENT '反馈联系方式',
  `feed_back_info` varchar(255) DEFAULT NULL COMMENT '反馈信息',
  `feed_back_pic` text COMMENT '反馈图片',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1、待处理;2、处理中；3、已完成]',
  `feed_back_results` varchar(255) DEFAULT NULL COMMENT '反馈处理结果',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '反馈时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='意见反馈';

-- ----------------------------
-- APP用户认证信息-发布车位
-- ----------------------------
DROP TABLE IF EXISTS `app_user_auth_p`;

CREATE TABLE `app_user_auth_p` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真是姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
  `phone` varchar(55) DEFAULT NULL COMMENT '联系电话',
  `front_of_idcard` varchar(255) DEFAULT NULL COMMENT '身份证正面',
  `reverse_of_idcard` varchar(255) DEFAULT NULL COMMENT '身份证反面',
  `face_recognition` varchar(255) DEFAULT NULL COMMENT '人脸识别',
  `holding_id_photo` varchar(255) DEFAULT NULL COMMENT '手持身份证照片',
  `driver_license_original_photo` varchar(255) DEFAULT NULL COMMENT '驾驶证正本照片',
  `driver_license_copy_photo` varchar(255) DEFAULT NULL COMMENT '驾驶证副本照片',
  `detailed_address` varchar(255) DEFAULT NULL COMMENT '详细地址',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `app_user_auth_p_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='APP用户认证信息-发布车位';

-- ----------------------------
-- APP用户认证信息-发布汽车
-- ----------------------------
DROP TABLE IF EXISTS `app_user_auth_c`;

CREATE TABLE `app_user_auth_c` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真是姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
  `vehicle_brands` varchar(20) DEFAULT NULL COMMENT '车辆品牌',
  `vehicle_model` varchar(20) DEFAULT NULL COMMENT '车辆型号',
  `vehicle_specifications` varchar(20) DEFAULT NULL COMMENT '车辆规格',
  `vehicle_license_plate_number` varchar(20) DEFAULT NULL COMMENT '车辆车牌号',
  `vehicle_annual_inspection_time` varchar(20) DEFAULT NULL COMMENT '车辆年检时间',
  `front_of_idcard` varchar(255) DEFAULT NULL COMMENT '身份证正面',
  `reverse_of_idcard` varchar(255) DEFAULT NULL COMMENT '身份证反面',
  `face_recognition` varchar(255) DEFAULT NULL COMMENT '人脸识别',
  `holding_id_photo` varchar(255) DEFAULT NULL COMMENT '手持身份证',
  `driver_license_original_photo` varchar(255) DEFAULT NULL COMMENT '驾驶证正本',
  `driver_license_copy_photo` varchar(255) DEFAULT NULL COMMENT '驾驶证副本',
  `driving_license_original_photo` varchar(255) DEFAULT NULL COMMENT '行驶证正本',
  `driving_license_copy_photo` varchar(255) DEFAULT NULL COMMENT '行驶证副本',
  `vehicle_front` varchar(255) DEFAULT NULL COMMENT '车辆正面',
  `vehicle_left` varchar(255) DEFAULT NULL COMMENT '车辆左面',
  `vehicle_right` varchar(255) DEFAULT NULL COMMENT '车辆右面',
  `vehicle_back` varchar(255) DEFAULT NULL COMMENT '车辆背面',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `app_user_auth_c_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='APP用户认证信息-发布汽车';

-- ----------------------------
-- APP用户认证信息-发布租车
-- ----------------------------
DROP TABLE IF EXISTS `app_user_auth_cr`;

CREATE TABLE `app_user_auth_cr` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真是姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
  `front_of_idcard` varchar(255) DEFAULT NULL COMMENT '身份证正面',
  `reverse_of_idcard` varchar(255) DEFAULT NULL COMMENT '身份证反面',
  `face_recognition` varchar(255) DEFAULT NULL COMMENT '人脸识别',
  `driver_license_original_photo` varchar(255) DEFAULT NULL COMMENT '驾驶证正本照片',
  `driver_license_copy_photo` varchar(255) DEFAULT NULL COMMENT '驾驶证副本照片',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `app_user_auth_p_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='APP用户认证信息-发布租车';

-- ----------------------------
-- 产品分类
-- ----------------------------
DROP TABLE IF EXISTS `oshare_category`;

CREATE TABLE `oshare_category` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) DEFAULT NULL COMMENT '分类名称',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='产品分类';


-- ----------------------------
-- 产品
-- ----------------------------
DROP TABLE IF EXISTS `oshare_product`;
CREATE TABLE `oshare_product` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `category_id` int(20) NOT NULL COMMENT '分类ID',
  `name` varchar(64) DEFAULT NULL COMMENT '产品名称',
  `category_name` varchar(64) NOT NULL COMMENT '分类名称',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='产品';


-- ----------------------------
-- 人共享售后订单
-- ----------------------------
DROP TABLE IF EXISTS `pshare_after_sale_order`;
CREATE TABLE `pshare_after_sale_order` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_number` varchar(64) DEFAULT NULL COMMENT '订单号',
  `publisher_id` int(20) DEFAULT NULL COMMENT '发布人ID',
  `business` varchar(20) DEFAULT NULL COMMENT '商家',
  `orderer_id` int(20) DEFAULT NULL COMMENT '接单人ID',
  `title` varchar(64) DEFAULT NULL COMMENT '标题',
  `service_area` varchar(20) DEFAULT NULL COMMENT '服务区域省-市',
  `order_deposit` decimal(10,2) DEFAULT '0.00' COMMENT '接单押金',
  `corporate_deposit` decimal(10,2) DEFAULT '0.00' COMMENT '企业押金',
  `order_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单金额',
  `earliest_repair_time` varchar(20) DEFAULT NULL COMMENT '最早维修时间',
  `latest_repair_time` varchar(20) DEFAULT NULL COMMENT '最晚维修时间',
  `customer_name` varchar(20) DEFAULT NULL COMMENT '客户姓名',
  `customer_number` varchar(20) DEFAULT NULL COMMENT '客户号码',
  `customer_address` varchar(64) DEFAULT NULL COMMENT '客户地址',
  `customer_detailed_address` varchar(255) DEFAULT NULL COMMENT '客户详细地址',
  `customer_service_code` varchar(20) DEFAULT NULL COMMENT '客户服务码',
  `make_an_appointment` varchar(20) DEFAULT NULL COMMENT '预约上门时间',
  `repair_completion_time` varchar(20) DEFAULT NULL COMMENT '维修完成时间',
   `complete_time` datetime DEFAULT NULL COMMENT '完成时间',
  `accessories_information` varchar(255) DEFAULT NULL COMMENT '配件信息',
  `logistics_company` varchar(20) DEFAULT NULL COMMENT '物流公司',
  `shipment_number` varchar(50) DEFAULT NULL COMMENT '物流单号',
  `return_shipment_number` varchar(50) DEFAULT NULL COMMENT '返还物流单号',
  `return_parts_address` varchar(255) DEFAULT NULL COMMENT '返还配件地址',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1待审核;2待接单;3待预约;4已预约;5待付款;6已完成;7已退单;8已取消;9已作废(审核不通过)]',
  `chargeback_status` tinyint(2) DEFAULT '0' COMMENT '申请退单状态[1申请退单;2同意退单;3拒绝退单;]',
  `return_person` tinyint(2) DEFAULT '0' COMMENT '申请退单人[1企业;2接单人;]',
  `reason_for_chargeback` varchar(255) DEFAULT NULL COMMENT '申请退单理由',
  `application_for_voucher` text COMMENT '申请退单凭证',
  `reason_for_refusal` varchar(255) DEFAULT NULL COMMENT '拒绝退单理由',
  `rejection_voucher` text COMMENT '拒绝退单凭证',
  `processing_result_analysis` varchar(255) DEFAULT NULL COMMENT '处理结果分析',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `evaluation_user` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否评价 0:未评价;1:企业已评价;2;接单人已评价;3:都已评价',
  `appeal_status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '申诉状态  1:待审核;  2:已完成',
  `del_status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '删除状态 1:企业;2:接单人;3全部',
  `pay_time` int(5) NOT NULL DEFAULT '7' COMMENT '付款时间默认7天，点击延迟付款增加默认时间',
  `delay_pay` tinyint(2) NOT NULL DEFAULT '0' COMMENT '延迟付款: 0:未延迟 1:延迟付款',
  `delay_completion` tinyint(2) NOT NULL DEFAULT '0' COMMENT '延迟完成:1、申请延迟  2、商家同意 3、商家拒绝',
  `delay_time` varchar(50) DEFAULT NULL COMMENT '延迟完成时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `delay_reason` varchar(255) DEFAULT NULL COMMENT '延迟完成理由',
  `delay_annex` text COMMENT '延迟附件',
  `scene_photos` text COMMENT '现场照片',
  `receiving_time` datetime DEFAULT NULL COMMENT '接单时间',
  PRIMARY KEY (`id`),
  KEY `pshare_after_sale_order_order_number` (`order_number`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享售后订单';

-- ----------------------------
-- 人共享售后订单维修内容
-- ----------------------------
DROP TABLE IF EXISTS `pshare_after_sale_order_content`;
CREATE TABLE `pshare_after_sale_order_content` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_id` int(20) DEFAULT NULL COMMENT '订单ID',
  `name_model` varchar(20) DEFAULT NULL COMMENT '名称型号',
  `quantity` varchar(20) DEFAULT NULL COMMENT '数量',
  `failure_phenomenon` varchar(64) DEFAULT NULL COMMENT '故障现象',
  `failure_analysis` varchar(64) DEFAULT NULL COMMENT '故障分析',
  `technical_support` varchar(50) DEFAULT NULL COMMENT '技术支持',
  `phone` varchar(20) DEFAULT NULL COMMENT '电话',
  `claim` varchar(60) DEFAULT NULL COMMENT '要求',
  `maintenance_price` decimal(10,2) DEFAULT '0.00' COMMENT '维修价格',
  PRIMARY KEY (`id`),
  KEY `pshare_after_sale_order_maintenance_content_order_id` (`order_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享售后订单维修内容';

CREATE TABLE `pshare_after_sale_appeal` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `order_id` int(20) NOT NULL COMMENT '订单ID',
  `order_number` varchar(64) NOT NULL COMMENT '订单号',
  `complainant` tinyint(2) DEFAULT NULL COMMENT '申诉方[1企业;2接单人]',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1待审核;2已处理;3已驳回;]',
  `reason_for_appeal` varchar(255) DEFAULT NULL COMMENT '申诉原因',
  `appeal_attachment` text COMMENT '申诉附件',
  `order_deposit` decimal(10,2) DEFAULT NULL COMMENT '接单保证金',
  `deduction_of_order_deposit` decimal(10,2) DEFAULT NULL COMMENT '扣除接单保证金',
  `order_deposit_beneficiary` tinyint(2) NOT NULL DEFAULT '0' COMMENT '接单押金受益人',
  `corporate_deposit` decimal(10,2) DEFAULT NULL COMMENT '企业保证金',
  `deduction_of_corporate_deposit` decimal(10,2) DEFAULT NULL COMMENT '扣除企业保证金',
  `corporate_deposit_beneficiary` tinyint(2) NOT NULL DEFAULT '0' COMMENT '企业保证金受益人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `pshare_after_sale_order_order_id` (`order_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='人共享售后申诉';
-- ----------------------------
-- 金额明细
-- ----------------------------
DROP TABLE IF EXISTS `amount_details`;
CREATE TABLE `amount_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(20) NOT NULL COMMENT '用户',
  `order_id` int(20) NOT NULL COMMENT '订单ID',
  `type` tinyint(2) DEFAULT NULL COMMENT '类型[1收入;2支出]',
  `amount` decimal(10,2) DEFAULT NULL COMMENT '金额',
  `remark` varchar(64) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `amount_details_user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='金额明细';

-- ----------------------------
-- 帮助中心
-- ----------------------------
DROP TABLE IF EXISTS `help_center`;
CREATE TABLE `help_center` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `title` varchar(64) DEFAULT NULL COMMENT '标题',
  `content` text DEFAULT NULL COMMENT '内容',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='帮助中心';

DROP TABLE IF EXISTS `oshare_drop_site`;
CREATE TABLE `oshare_drop_site` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) DEFAULT NULL COMMENT '站点名称',
  `contact_number` varchar(20) DEFAULT NULL COMMENT '站点联系电话',
  `address` varchar(30) DEFAULT NULL COMMENT '站点地址',
  `longitude` varchar(100) DEFAULT NULL COMMENT '经度',
  `latitude` varchar(100) DEFAULT NULL COMMENT '纬度',
  `deposit` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '站点押金',
  `site_user_id` int(20) DEFAULT NULL COMMENT '站点用户',
  `type` varchar(10) DEFAULT NULL COMMENT '1 净化器设备 2车位 3汽车',
  `contract` text COMMENT '合同',
  `founder` int(20) NOT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='站点';


DROP TABLE IF EXISTS `oshare_rent_rules`;
CREATE TABLE `oshare_rent_rules` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) DEFAULT NULL COMMENT '规则名称',
  `drop_site_id` varchar(20) DEFAULT NULL COMMENT '站点ID',
  `overtime_time` int(10) DEFAULT NULL COMMENT '超时时间',
	`overtime_type` tinyint(2) DEFAULT NULL COMMENT '超时类型：1分；2时；3天',
  `overtime_fee` decimal(10,2) DEFAULT '0.00' COMMENT '超时费用',
	`status` tinyint(2) DEFAULT '1' COMMENT '是否在用1是;2否;',
  `charge_price` text DEFAULT NULL COMMENT '收费价格',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='租金规则';

DROP TABLE IF EXISTS `application_management`;
CREATE TABLE `application_management` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `remark` varchar(64) DEFAULT NULL COMMENT '备注',
  `type` tinyint(2) DEFAULT NULL COMMENT '类型[1人共享;2物共享；]',
  `status` tinyint(2) DEFAULT NULL COMMENT '状态 1正常2禁用',
  `login_visit` tinyint(2) DEFAULT '1' COMMENT '是否登陆访问 1是2否',
  `sort` int(10) DEFAULT NULL COMMENT '排序',
  `pic_url` varchar(255) DEFAULT NULL COMMENT '图片地址',
  `access_url_b` varchar(255) DEFAULT NULL COMMENT '访问地址商家',
  `access_url_o` varchar(255) DEFAULT NULL COMMENT '访问地址接单人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='应用管理';

DROP TABLE IF EXISTS `pshare_business_order`;
CREATE TABLE `pshare_business_order` (
    `id` int(20) NOT NULL AUTO_INCREMENT,
    `order_number` varchar(64) DEFAULT NULL COMMENT '订单号',
	`publisher_id` int(20) DEFAULT NULL COMMENT '发布人ID',
	`orderer_id` int(20) DEFAULT NULL COMMENT '接单人ID',
	`title` varchar(64) DEFAULT NULL COMMENT '标题',
	`business` varchar(64) DEFAULT NULL COMMENT '商家',
	`service_area` varchar(20) DEFAULT NULL COMMENT '服务区域省',
	`service_area_city` varchar(20) DEFAULT NULL COMMENT '服务区域市',
	`order_deposit` decimal(10,2) DEFAULT '0.00' COMMENT '接单押金',
	`order_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单金额',
	`earliest_business_time` varchar(20) DEFAULT NULL COMMENT '最早业务时间',
	`latest_business_time` varchar(20) DEFAULT NULL COMMENT '最晚业务时间',
	`company_name` varchar(50) DEFAULT NULL COMMENT '企业名称',
	`business_registration_number` varchar(60) DEFAULT NULL COMMENT '营业注册号',
	`company_address` varchar(64) DEFAULT NULL COMMENT '企业地址',
	`contact_number` varchar(20) DEFAULT NULL COMMENT '联系电话',
    `contact_person` varchar(20) DEFAULT NULL COMMENT '联系人',
	`business_card` varchar(255) DEFAULT NULL COMMENT '名片',
	`price_list` varchar(255) DEFAULT NULL COMMENT '价目表',
    `flyer` varchar(255) DEFAULT NULL COMMENT '宣传单',
	`catalog` varchar(255) DEFAULT NULL COMMENT '目录本',
    `backpack` varchar(50) DEFAULT NULL COMMENT '背包',
	`work_clothes` varchar(50) DEFAULT NULL COMMENT '工作服',
	`data_location` varchar(255) DEFAULT NULL COMMENT '资料地址',
	`business_report_template` text DEFAULT NULL COMMENT '业务报表模板',
	`appointment_start_time` varchar(20) DEFAULT NULL COMMENT '预约开始时间',
	`appointment_end_time` varchar(20) DEFAULT NULL COMMENT '预约结束时间',
	`business_video` varchar(255) DEFAULT NULL COMMENT '业务视频',
	`shipping_address` varchar(255) DEFAULT NULL COMMENT '收货地址',
	`status` tinyint(2) DEFAULT '1' COMMENT '状态[1待审核;2待接单;3待预约;4已预约;5待付款;6已完成;7已退单;8已取消;9已作废(审核不通过)]',
    `chargeback_status` tinyint(2) DEFAULT '0' COMMENT '申请退单状态[1申请退单;2同意退单;3拒绝退单;]',
    `return_person` tinyint(2) DEFAULT '0' COMMENT '申请退单人[1企业;2接单人;]',
    `reason_for_chargeback` varchar(255) DEFAULT NULL COMMENT '申请退单理由',
    `application_for_voucher` text COMMENT '申请退单凭证',
    `reason_for_refusal` varchar(255) DEFAULT NULL COMMENT '拒绝退单理由',
    `rejection_voucher` text COMMENT '拒绝退单凭证',
     `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
    `evaluation_user` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否评价 0:未评价;1:企业已评价;2;接单人已评价;3:都已评价',
    `appeal_status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '申诉状态  1:待审核;  2:已完成',
    `del_status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '删除状态 1:企业;2:接单人;3全部',
    `pay_time` int(5) NOT NULL DEFAULT '7' COMMENT '付款时间默认7天，点击延迟付款增加默认时间',
    `delay_pay` tinyint(2) NOT NULL DEFAULT '0' COMMENT '延迟付款: 0:未延迟 1:延迟付款',
    `delay_completion` tinyint(2) NOT NULL DEFAULT '0' COMMENT '延迟完成:1、申请延迟  2、商家同意 3、商家拒绝',
    `delay_time` varchar(50) DEFAULT NULL COMMENT '延迟完成时间',
    `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `delay_reason` varchar(255) DEFAULT NULL COMMENT '延迟完成理由',
    `delay_annex` text COMMENT '延迟附件',
    `market_picture` text COMMENT '市场图片',
    `complete_time` datetime DEFAULT NULL COMMENT '完成时间',
    `receiving_time` datetime DEFAULT NULL COMMENT '接单时间',
    PRIMARY KEY (`id`),
	KEY `oshare_business_order_order_number` (`order_number`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享业务订单';

DROP TABLE IF EXISTS `pshare_business_order_content`;
CREATE TABLE `pshare_business_order_content` (
    `id` int(20) NOT NULL AUTO_INCREMENT,
    `order_id` int(20) DEFAULT NULL COMMENT '订单id',
	`business_name` varchar(64) DEFAULT NULL COMMENT '业务名称',
	`working_days` varchar(20) DEFAULT NULL COMMENT '出勤天数',
	`work_content` varchar(255) DEFAULT NULL COMMENT '工作内容',
	`examination_content` varchar(255) DEFAULT NULL COMMENT '考核内容',
	`efficient_market` varchar(20) DEFAULT NULL COMMENT '有效建材市场',
	`active_customers` varchar(20) DEFAULT NULL COMMENT '有效客户数',
	`effective_distribution_store` varchar(20) DEFAULT NULL COMMENT '有效分销店',
	`effective_experience_store` varchar(20) DEFAULT NULL COMMENT '有效体验店',
	`bonus_system` text DEFAULT NULL COMMENT '奖励机制',
	`penalties` text DEFAULT NULL COMMENT '处罚机制',
	`technical_support` varchar(255) DEFAULT NULL COMMENT '技术支持',
	`phone` varchar(20) DEFAULT NULL COMMENT '电话',
	`claim` varchar(255) DEFAULT NULL COMMENT '要求',
	`business_price` decimal(10,2) DEFAULT '0.00' COMMENT '业务价格',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享业务订单内容';

DROP TABLE IF EXISTS `pshare_business_appeal`;
CREATE TABLE `pshare_business_appeal` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `order_id` int(20) NOT NULL COMMENT '订单ID',
  `order_number` varchar(64) NOT NULL COMMENT '订单号',
  `complainant` tinyint(2) DEFAULT NULL COMMENT '申诉方[1企业;2接单人]',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1待审核;2已处理;3已驳回;]',
  `reason_for_appeal` varchar(255) DEFAULT NULL COMMENT '申诉原因',
  `appeal_attachment` text COMMENT '申诉附件',
  `order_deposit` decimal(10,2) DEFAULT NULL COMMENT '接单保证金',
  `deduction_of_order_deposit` decimal(10,2) DEFAULT NULL COMMENT '扣除接单保证金',
  `order_deposit_beneficiary` tinyint(2) NOT NULL DEFAULT '0' COMMENT '接单押金受益人',
  `corporate_deposit` decimal(10,2) DEFAULT NULL COMMENT '企业保证金',
  `deduction_of_corporate_deposit` decimal(10,2) DEFAULT NULL COMMENT '扣除企业保证金',
  `corporate_deposit_beneficiary` tinyint(2) NOT NULL DEFAULT '0' COMMENT '企业保证金受益人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `pshare_business_order_order_id` (`order_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享业务申诉';


DROP TABLE IF EXISTS `pshare_timing_order`;
CREATE TABLE `pshare_timing_order` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_number` varchar(64) DEFAULT NULL COMMENT '订单号',
  `publisher_id` int(20) DEFAULT NULL COMMENT '发布人ID',
  `business` varchar(20) DEFAULT NULL COMMENT '商家',
  `orderer_id` int(20) DEFAULT NULL COMMENT '接单人ID',
  `title` varchar(64) DEFAULT NULL COMMENT '标题',
  `service_area` varchar(20) DEFAULT NULL COMMENT '服务区域',
  `order_deposit` decimal(10,2) DEFAULT '0.00' COMMENT '接单押金',
  `order_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单金额',
  `work_start_time` varchar(20) DEFAULT NULL COMMENT '工作开始时间',
  `work_end_time` varchar(20) DEFAULT NULL COMMENT '工作结束时间',
  `work_place` varchar(100) DEFAULT NULL COMMENT '工作地点',
  `job_name` varchar(20) DEFAULT NULL COMMENT '工作名称',
  `hourly_wage` decimal(10,2) DEFAULT NULL COMMENT '计时工资',
  `required_quantity` decimal(10,2) DEFAULT NULL COMMENT '完成数量要求',
  `completion_time_requirements` decimal(10,2) DEFAULT NULL COMMENT '完成时间要求',
  `pass_quantity` int(10) DEFAULT NULL COMMENT '合格数量要求',
  `defectives_quantity` int(10) DEFAULT NULL COMMENT '次品数量要求',
  `rejection_quantity` int(10) DEFAULT NULL COMMENT '废品数量要求',
  `pass_rate` decimal(10,2) DEFAULT NULL COMMENT '合格品率',
  `defective_rate` decimal(10,2) DEFAULT NULL COMMENT '次品率',
  `rejection_rate` decimal(10,2) DEFAULT NULL COMMENT '废品率',
  `work_content` varchar(255) DEFAULT NULL COMMENT '工作内容',
  `work_content_pic` text COMMENT '工作内容图片',
  `examination_content` varchar(255) DEFAULT NULL COMMENT '考核内容',
  `bonus_system` varchar(255) DEFAULT NULL COMMENT '奖励机制',
  `penalties` varchar(255) DEFAULT NULL COMMENT '处罚机制',
  `job_requirements` varchar(255) DEFAULT NULL COMMENT '岗位要求',
  `company_name` varchar(50) DEFAULT NULL COMMENT '企业名称',
  `business_registration_number` varchar(100) DEFAULT NULL COMMENT '营业注册号',
  `company_address` varchar(64) DEFAULT NULL COMMENT '企业地址',
  `contact_number` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `contact_person` varchar(20) DEFAULT NULL COMMENT '联系人',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1待审核;2待接单;3待预约;4已预约;5待付款;6已完成;7已退单;8已取消;9已作废(审核不通过)]',
  `appointment_start_time` varchar(50) DEFAULT NULL COMMENT '预约开始时间',
  `chargeback_status` tinyint(2) DEFAULT '0' COMMENT '申请退单状态[1申请退单;2同意退单;3拒绝退单;]',
  `return_person` tinyint(2) DEFAULT '0' COMMENT '申请退单人[1企业;2接单人;]',
  `reason_for_chargeback` varchar(255) DEFAULT NULL COMMENT '申请退单理由',
  `application_for_voucher` text COMMENT '申请退单凭证',
  `reason_for_refusal` varchar(255) DEFAULT NULL COMMENT '拒绝退单理由',
  `rejection_voucher` text COMMENT '拒绝退单凭证',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `evaluation_user` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否评价 0:未评价;1:企业已评价;2;接单人已评价;3:都已评价',
  `appeal_status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '申诉状态  1:待审核;  2:已完成',
  `del_status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '删除状态 1:企业;2:接单人;3全部',
  `pay_time` int(5) NOT NULL DEFAULT '7' COMMENT '付款时间默认7天，点击延迟付款增加默认时间',
  `delay_pay` tinyint(2) NOT NULL DEFAULT '0' COMMENT '延迟付款: 0:未延迟 1:延迟付款',
  `delay_completion` tinyint(2) NOT NULL DEFAULT '0' COMMENT '延迟完成:1、申请延迟  2、商家同意 3、商家拒绝',
  `delay_time` varchar(50) DEFAULT NULL COMMENT '延迟完成时间',
  `delay_reason` varchar(255) DEFAULT NULL COMMENT '延迟完成理由',
  `delay_annex` text COMMENT '延迟附件',
  `receiving_time` datetime DEFAULT NULL COMMENT '接单时间',
  `locations` text COMMENT '业务定位',
  `face_recognition` varchar(255) DEFAULT NULL COMMENT '人脸识别',
  `picking_code` varchar(20) DEFAULT NULL COMMENT '领料码',
  `confirm_picking_code` tinyint(2) NOT NULL DEFAULT '0' COMMENT '企业确认领料码 0未确认 1已确认',
  `actual_quantity` int(20) DEFAULT NULL COMMENT '实际完成数量',
  `qualified_quantity` int(20) DEFAULT NULL COMMENT '合格品数量',
  `defective_quantity` int(20) DEFAULT NULL COMMENT '次品数量',
  `scrap_quantity` int(20) DEFAULT NULL COMMENT '废品数量',
  `complete_time`  datetime DEFAULT NULL COMMENT '完成时间',
  `complete_review`  tinyint(2) NOT NULL DEFAULT '0' COMMENT '完成审核 0未审核 1已审核',
  `completion_code` varchar(20) DEFAULT NULL COMMENT '完成码',
  `stock_list` text COMMENT '备料清单',
    `review_pic` varchar(255) DEFAULT NULL COMMENT '审核图片',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `pshare_timing_order_order_number` (`order_number`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享计时订单';

DROP TABLE IF EXISTS `pshare_timing_appeal`;
CREATE TABLE `pshare_timing_appeal` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `order_id` int(20) NOT NULL COMMENT '订单ID',
  `order_number` varchar(64) NOT NULL COMMENT '订单号',
  `complainant` tinyint(2) DEFAULT NULL COMMENT '申诉方[1企业;2接单人]',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1待审核;2已处理;3已驳回;]',
  `reason_for_appeal` varchar(255) DEFAULT NULL COMMENT '申诉原因',
  `appeal_attachment` text COMMENT '申诉附件',
  `order_deposit` decimal(10,2) DEFAULT NULL COMMENT '接单保证金',
  `deduction_of_order_deposit` decimal(10,2) DEFAULT NULL COMMENT '扣除接单保证金',
  `order_deposit_beneficiary` tinyint(2) NOT NULL DEFAULT '0' COMMENT '接单押金受益人',
  `corporate_deposit` decimal(10,2) DEFAULT NULL COMMENT '企业保证金',
  `deduction_of_corporate_deposit` decimal(10,2) DEFAULT NULL COMMENT '扣除企业保证金',
  `corporate_deposit_beneficiary` tinyint(2) NOT NULL DEFAULT '0' COMMENT '企业保证金受益人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `pshare_timing_order_order_id` (`order_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享计时申诉';

DROP TABLE IF EXISTS `pshare_after_sale_order_user`;
CREATE TABLE `pshare_after_sale_order_user` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `order_id` int(10) DEFAULT NULL COMMENT '订单ID',
  `user_id` int(10) DEFAULT NULL COMMENT '接单人ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享售后订单与接单人关联表';

DROP TABLE IF EXISTS `pshare_business_order_user`;
CREATE TABLE `pshare_business_order_user` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `order_id` int(10) DEFAULT NULL COMMENT '订单ID',
  `user_id` int(10) DEFAULT NULL COMMENT '接单人ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享业务订单与接单人关联表';

DROP TABLE IF EXISTS `pshare_timing_order_user`;
CREATE TABLE `pshare_timing_order_user` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `order_id` int(10) DEFAULT NULL COMMENT '订单ID',
  `user_id` int(10) DEFAULT NULL COMMENT '接单人ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享计时订单与接单人关联表';

DROP TABLE IF EXISTS `pshare_after_sale_order_t`;
CREATE TABLE `pshare_after_sale_order_t` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `publisher_id` int(20) DEFAULT NULL COMMENT '发布人ID',
  `business` varchar(20) DEFAULT NULL COMMENT '商家',
  `title` varchar(64) DEFAULT NULL COMMENT '标题',
  `service_area` varchar(20) DEFAULT NULL COMMENT '服务区域省-市',
  `order_deposit` decimal(10,2) DEFAULT '0.00' COMMENT '接单押金',
  `corporate_deposit` decimal(10,2) DEFAULT '0.00' COMMENT '企业押金',
  `order_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单金额',
  `earliest_repair_time` varchar(20) DEFAULT NULL COMMENT '最早维修时间',
  `latest_repair_time` varchar(20) DEFAULT NULL COMMENT '最晚维修时间',
  `customer_name` varchar(20) DEFAULT NULL COMMENT '客户姓名',
  `customer_number` varchar(20) DEFAULT NULL COMMENT '客户号码',
  `customer_address` varchar(64) DEFAULT NULL COMMENT '客户地址',
  `customer_detailed_address` varchar(255) DEFAULT NULL COMMENT '客户详细地址',
  `make_an_appointment` varchar(20) DEFAULT NULL COMMENT '预约上门时间',
  `repair_completion_time` varchar(20) DEFAULT NULL COMMENT '维修完成时间',
  `accessories_information` varchar(255) DEFAULT NULL COMMENT '配件信息',
  `logistics_company` varchar(20) DEFAULT NULL COMMENT '物流公司',
  `shipment_number` varchar(20) DEFAULT NULL COMMENT '物流单号',
  `return_parts_address` varchar(50) DEFAULT NULL COMMENT '返还配件地址',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享售后订单模板';

DROP TABLE IF EXISTS `pshare_after_sale_order_content_t`;
CREATE TABLE `pshare_after_sale_order_content_t` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_id` int(20) DEFAULT NULL COMMENT '订单ID',
  `name_model` varchar(20) DEFAULT NULL COMMENT '名称型号',
  `quantity` varchar(20) DEFAULT NULL COMMENT '数量',
  `failure_phenomenon` varchar(64) DEFAULT NULL COMMENT '故障现象',
  `failure_analysis` varchar(64) DEFAULT NULL COMMENT '故障分析',
  `technical_support` varchar(50) DEFAULT NULL COMMENT '技术支持',
  `phone` varchar(20) DEFAULT NULL COMMENT '电话',
  `claim` varchar(60) DEFAULT NULL COMMENT '要求',
  `maintenance_price` decimal(10,2) DEFAULT '0.00' COMMENT '维修价格',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享售后订单维修内容模板';

DROP TABLE IF EXISTS `pshare_business_order_t`;
CREATE TABLE `pshare_business_order_t` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `publisher_id` int(20) DEFAULT NULL COMMENT '发布人ID',
  `business` varchar(25) DEFAULT NULL COMMENT '商家',
  `title` varchar(64) DEFAULT NULL COMMENT '标题',
  `service_area` varchar(20) DEFAULT NULL COMMENT '服务区域',
  `order_deposit` decimal(10,2) DEFAULT '0.00' COMMENT '接单押金',
  `order_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单金额',
  `earliest_business_time` varchar(20) DEFAULT NULL COMMENT '最早业务时间',
  `latest_business_time` varchar(20) DEFAULT NULL COMMENT '最晚业务时间',
  `company_name` varchar(50) DEFAULT NULL COMMENT '企业名称',
  `business_registration_number` varchar(60) DEFAULT NULL COMMENT '营业注册号',
  `company_address` varchar(64) DEFAULT NULL COMMENT '企业地址',
  `contact_number` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `contact_person` varchar(20) DEFAULT NULL COMMENT '联系人',
  `business_card` varchar(255) DEFAULT NULL COMMENT '名片',
  `price_list` varchar(255) DEFAULT NULL COMMENT '价目表',
  `flyer` varchar(255) DEFAULT NULL COMMENT '宣传单',
  `catalog` varchar(255) DEFAULT NULL COMMENT '目录本',
  `backpack` varchar(50) DEFAULT NULL COMMENT '背包',
  `work_clothes` varchar(50) DEFAULT NULL COMMENT '工作服',
  `business_report_template` text COMMENT '业务报表模板',
  `business_video` varchar(255) DEFAULT NULL COMMENT '业务视频',
  `shipping_address` varchar(255) DEFAULT NULL COMMENT '收货地址',
  `data_location` varchar(255) DEFAULT NULL COMMENT '资料地址',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享业务订单模板';

DROP TABLE IF EXISTS `pshare_business_order_content_t`;
CREATE TABLE `pshare_business_order_content_t` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_id` int(20) DEFAULT NULL COMMENT '订单id',
  `business_name` varchar(64) DEFAULT NULL COMMENT '业务名称',
  `working_days` varchar(20) DEFAULT NULL COMMENT '出勤天数',
  `work_content` varchar(255) DEFAULT NULL COMMENT '工作内容',
  `examination_content` varchar(255) DEFAULT NULL COMMENT '考核内容',
  `efficient_market` varchar(20) DEFAULT NULL COMMENT '有效建材市场',
  `active_customers` varchar(20) DEFAULT NULL COMMENT '有效客户数',
  `effective_distribution_store` varchar(20) DEFAULT NULL COMMENT '有效分销店',
  `effective_experience_store` varchar(20) DEFAULT NULL COMMENT '有效体验店',
  `bonus_system` text COMMENT '奖励机制',
  `penalties` text COMMENT '处罚机制',
  `technical_support` varchar(255) DEFAULT NULL COMMENT '技术支持',
  `phone` varchar(20) DEFAULT NULL COMMENT '电话',
  `claim` varchar(255) DEFAULT NULL COMMENT '要求',
  `business_price` decimal(10,2) DEFAULT '0.00' COMMENT '业务价格',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享业务订单内容模板';

DROP TABLE IF EXISTS `oshare_parking_space`;
CREATE TABLE `oshare_parking_space` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `publisher_id` int(20) DEFAULT NULL COMMENT '车发布人',
  `type` tinyint(2) DEFAULT NULL COMMENT '车位类型 1露天 2室内',
  `label` varchar(64) DEFAULT NULL COMMENT '车位标签',
  `positioning` varchar(255) DEFAULT NULL COMMENT '车位定位',
  `numbering` varchar(64) DEFAULT NULL COMMENT '车位编号',
  `license_plate` varchar(64) DEFAULT NULL COMMENT '车牌',
  `drop_site_id` int(20) DEFAULT NULL COMMENT '所属站点',
  `pic` varchar(255) DEFAULT NULL COMMENT '车位照片',
  `start_time` varchar(30) DEFAULT NULL COMMENT '共享开始时间',
  `end_time` varchar(30) DEFAULT NULL COMMENT '共享结束时间',
  `hourly_price` decimal(10,2) DEFAULT NULL COMMENT '时租价格',
  `day_cap` decimal(10,2) DEFAULT NULL COMMENT '当日封顶',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态 1:待审核;2:可租用;3:不可租;4:不通过[审核不通过]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='车位信息管理';

DROP TABLE IF EXISTS `oshare_parking_space_order`;
CREATE TABLE `oshare_parking_space_order` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_number` varchar(64) DEFAULT NULL COMMENT '订单号',
  `user_id` int(20) DEFAULT NULL COMMENT '租户',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态 1:待支付;2:待进门;3:待出门;4:已完成;5:已取消',
  `parking_space_id` int(20) DEFAULT NULL COMMENT '车位ID',
  `drop_site_id` int(20) DEFAULT NULL COMMENT '所属站点',
  `deposit` decimal(10,2) DEFAULT NULL COMMENT '押金',
  `order_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单金额',
  `order_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '下单时间',
  `review_time` datetime DEFAULT NULL COMMENT '审核时间',
  `use_time` int(20) DEFAULT NULL COMMENT '使用时长（/时）',
  `payment_method` tinyint(2) DEFAULT NULL COMMENT '支付方式 1:余额;2:微信;3:支付宝',
  `payment_time` datetime DEFAULT NULL COMMENT '支付时间',
  `start_time` datetime DEFAULT NULL COMMENT '开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '结束时间',
  `lease_order_overtime` int(5) DEFAULT NULL COMMENT '未付款时自动取消时间',
  `number_plate` varchar(30) DEFAULT NULL COMMENT '车牌号',
  `entry_code` varchar(50) DEFAULT NULL COMMENT '进门码',
  `exit_code` varchar(50) DEFAULT NULL COMMENT '出门码',
  `entry_time` datetime DEFAULT NULL COMMENT '进门时间',
  `exit_time` datetime DEFAULT NULL COMMENT '出门时间',
  `early_entry_amount` decimal(10,2) DEFAULT '0.00' COMMENT '提前进门金额',
   `overtime` int(10) DEFAULT '0' COMMENT '超时时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='车位订单';

DROP TABLE IF EXISTS `oshare_car`;
CREATE TABLE `oshare_car` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `product_id` int(11) DEFAULT NULL COMMENT '产品ID',
  `publisher_id` int(20) DEFAULT NULL COMMENT '发布人',
  `drop_site_id` int(20) DEFAULT NULL COMMENT '站点ID',
  `vehicle_brands` varchar(20) DEFAULT NULL COMMENT '车辆品牌',
  `vehicle_model` varchar(20) DEFAULT NULL COMMENT '车辆型号',
  `vehicle_specifications` varchar(20) DEFAULT NULL COMMENT '车辆规格',
  `vehicle_license_plate_number` varchar(20) DEFAULT NULL COMMENT '车辆车牌号',
  `vehicle_annual_inspection_time` varchar(20) DEFAULT NULL COMMENT '车辆年检时间',
  `numbering` varchar(50) DEFAULT NULL COMMENT '车位编号',
  `driving_license_original_photo` varchar(255) DEFAULT NULL COMMENT '行驶证正本',
  `driving_license_copy_photo` varchar(255) DEFAULT NULL COMMENT '行驶证副本',
  `start_time` varchar(30) DEFAULT NULL COMMENT '共享开始时间',
  `end_time` varchar(30) DEFAULT NULL COMMENT '共享结束时间',
  `hourly_price` decimal(10,2) DEFAULT NULL COMMENT '时租价格',
  `day_cap` decimal(10,2) DEFAULT NULL COMMENT '当日封顶',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态 1:待审核;2:可租用;3:不可租;4:不通过[审核不通过]',
  `vehicle_front` varchar(255) DEFAULT NULL COMMENT '车辆正面',
  `vehicle_left` varchar(255) DEFAULT NULL COMMENT '车辆左面',
  `vehicle_right` varchar(255) DEFAULT NULL COMMENT '车辆右面',
  `vehicle_back` varchar(255) DEFAULT NULL COMMENT '车辆背面',
  `key_on_site` tinyint(2) DEFAULT NULL COMMENT '钥匙是否在站点 1:是;2:否;',
  `insurance_start_time` varchar(30) DEFAULT NULL COMMENT '保险开始时间',
  `insurance_end_time` varchar(30) DEFAULT NULL COMMENT '保险结束时间',
  `insurance_limit` decimal(10,2) DEFAULT NULL COMMENT '保险额度',
  `traffic_accident` tinyint(2) DEFAULT NULL COMMENT '有无交通事故 1:有;2:无;',
  `driven_distance` varchar(30) DEFAULT NULL COMMENT '行驶里程',
  `emergency_contact` varchar(30) DEFAULT NULL COMMENT '紧急联系人',
  `contact_number` varchar(30) DEFAULT NULL COMMENT '联系人电话',
  `mailing_address` varchar(30) DEFAULT NULL COMMENT '通讯地址',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='发布汽车管理';

DROP TABLE IF EXISTS `pshare_piece_order`;
CREATE TABLE `pshare_piece_order` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_number` varchar(64) DEFAULT NULL COMMENT '订单号',
  `publisher_id` int(20) DEFAULT NULL COMMENT '发布人ID',
  `business` varchar(20) DEFAULT NULL COMMENT '商家',
  `orderer_id` int(20) DEFAULT NULL COMMENT '接单人ID',
  `title` varchar(64) DEFAULT NULL COMMENT '标题',
  `service_area` varchar(20) DEFAULT NULL COMMENT '服务区域',
  `order_deposit` decimal(10,2) DEFAULT '0.00' COMMENT '接单押金',
  `order_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单金额',
  `work_start_time` varchar(20) DEFAULT NULL COMMENT '工作开始时间',
  `work_end_time` varchar(20) DEFAULT NULL COMMENT '工作结束时间',
  `work_place` varchar(100) DEFAULT NULL COMMENT '工作地点',
  `job_name` varchar(20) DEFAULT NULL COMMENT '工作名称',
  `piece_rate` decimal(10,2) DEFAULT NULL COMMENT '计时工资',
  `required_quantity` decimal(10,2) DEFAULT NULL COMMENT '完成数量要求',
  `completion_time_requirements` decimal(10,2) DEFAULT NULL COMMENT '完成时间要求',
  `pass_quantity` int(10) DEFAULT NULL COMMENT '合格数量要求',
  `defectives_quantity` int(10) DEFAULT NULL COMMENT '次品数量要求',
  `rejection_quantity` int(10) DEFAULT NULL COMMENT '废品数量要求',
  `pass_rate` decimal(10,2) DEFAULT NULL COMMENT '合格品率',
  `defective_rate` decimal(10,2) DEFAULT NULL COMMENT '次品率',
  `rejection_rate` decimal(10,2) DEFAULT NULL COMMENT '废品率',
  `work_content` varchar(255) DEFAULT NULL COMMENT '工作内容',
  `work_content_pic` text COMMENT '工作内容图片',
  `examination_content` varchar(255) DEFAULT NULL COMMENT '考核内容',
  `bonus_system` varchar(255) DEFAULT NULL COMMENT '奖励机制',
  `penalties` varchar(255) DEFAULT NULL COMMENT '处罚机制',
  `job_requirements` varchar(255) DEFAULT NULL COMMENT '岗位要求',
  `company_name` varchar(50) DEFAULT NULL COMMENT '企业名称',
  `business_registration_number` varchar(100) DEFAULT NULL COMMENT '营业注册号',
  `company_address` varchar(64) DEFAULT NULL COMMENT '企业地址',
  `contact_number` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `contact_person` varchar(20) DEFAULT NULL COMMENT '联系人',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1待审核;2待接单;3待预约;4已预约;5待付款;6已完成;7已退单;8已取消;9已作废(审核不通过)]',
  `appointment_start_time` varchar(50) DEFAULT NULL COMMENT '预约开始时间',
  `chargeback_status` tinyint(2) DEFAULT '0' COMMENT '申请退单状态[1申请退单;2同意退单;3拒绝退单;]',
  `return_person` tinyint(2) DEFAULT '0' COMMENT '申请退单人[1企业;2接单人;]',
  `reason_for_chargeback` varchar(255) DEFAULT NULL COMMENT '申请退单理由',
  `application_for_voucher` text COMMENT '申请退单凭证',
  `reason_for_refusal` varchar(255) DEFAULT NULL COMMENT '拒绝退单理由',
  `rejection_voucher` text COMMENT '拒绝退单凭证',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
   `evaluation_user` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否评价 0:未评价;1:企业已评价;2;接单人已评价;3:都已评价',
  `appeal_status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '申诉状态  1:待审核;  2:已完成',
  `del_status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '删除状态 1:企业;2:接单人;3全部',
  `pay_time` int(5) NOT NULL DEFAULT '7' COMMENT '付款时间默认7天，点击延迟付款增加默认时间',
  `delay_pay` tinyint(2) NOT NULL DEFAULT '0' COMMENT '延迟付款: 0:未延迟 1:延迟付款',
  `delay_completion` tinyint(2) NOT NULL DEFAULT '0' COMMENT '延迟完成:1、申请延迟  2、商家同意 3、商家拒绝',
  `delay_time` varchar(50) DEFAULT NULL COMMENT '延迟完成时间',
  `delay_reason` varchar(255) DEFAULT NULL COMMENT '延迟完成理由',
  `delay_annex` text COMMENT '延迟附件',
  `receiving_time` datetime DEFAULT NULL COMMENT '接单时间',
   `locations` text COMMENT '业务定位',
  `face_recognition` varchar(255) DEFAULT NULL COMMENT '人脸识别',
  `picking_code` varchar(20) DEFAULT NULL COMMENT '领料码',
  `confirm_picking_code` tinyint(2) NOT NULL DEFAULT '0' COMMENT '企业确认领料码 0未确认 1已确认',
  `actual_quantity` int(10) DEFAULT NULL COMMENT '实际完成数量',
  `qualified_quantity` int(10) DEFAULT NULL COMMENT '合格品数量',
  `defective_quantity` int(10) DEFAULT NULL COMMENT '次品数量',
  `scrap_quantity` int(10) DEFAULT NULL COMMENT '废品数量',
  `complete_review` tinyint(2) NOT NULL DEFAULT '0' COMMENT '完成审核 0未审核 1已审核',
  `completion_code` varchar(20) DEFAULT NULL COMMENT '完成码',
  `stock_list` text COMMENT '备料清单',
  `review_pic` varchar(255) DEFAULT NULL COMMENT '审核图片',
  `complete_time` datetime DEFAULT NULL COMMENT '完成时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `pshare_piece_order_order_number` (`order_number`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享计件订单';

DROP TABLE IF EXISTS `pshare_piece_appeal`;
CREATE TABLE `pshare_piece_appeal` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `order_id` int(20) NOT NULL COMMENT '订单ID',
  `order_number` varchar(64) NOT NULL COMMENT '订单号',
  `complainant` tinyint(2) DEFAULT NULL COMMENT '申诉方[1企业;2接单人]',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1待审核;2已处理;3已驳回;]',
  `reason_for_appeal` varchar(255) DEFAULT NULL COMMENT '申诉原因',
  `appeal_attachment` text COMMENT '申诉附件',
  `order_deposit` decimal(10,2) DEFAULT NULL COMMENT '接单保证金',
  `deduction_of_order_deposit` decimal(10,2) DEFAULT NULL COMMENT '扣除接单保证金',
  `order_deposit_beneficiary` tinyint(2) NOT NULL DEFAULT '0' COMMENT '接单押金受益人',
  `corporate_deposit` decimal(10,2) DEFAULT NULL COMMENT '企业保证金',
  `deduction_of_corporate_deposit` decimal(10,2) DEFAULT NULL COMMENT '扣除企业保证金',
  `corporate_deposit_beneficiary` tinyint(2) NOT NULL DEFAULT '0' COMMENT '企业保证金受益人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `pshare_piece_appeal_order_id` (`order_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享计件申诉';


DROP TABLE IF EXISTS `pshare_piece_order_user`;
CREATE TABLE `pshare_piece_order_user` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `order_id` int(10) DEFAULT NULL COMMENT '订单ID',
  `user_id` int(10) DEFAULT NULL COMMENT '接单人ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享计件订单与接单人关联表';

DROP TABLE IF EXISTS `oshare_car_order`;
CREATE TABLE `oshare_car_order` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_number` varchar(64) DEFAULT NULL COMMENT '订单号',
  `user_id` int(20) DEFAULT NULL COMMENT '租户',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态 1:待支付;2:待取车;3:待还车;4:已完成;5:已取消',
  `car_id` int(20) DEFAULT NULL COMMENT '汽车ID',
  `drop_site_id` int(20) DEFAULT NULL COMMENT '所属站点',
  `deposit` decimal(10,2) DEFAULT NULL COMMENT '押金',
  `order_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单金额',
  `order_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '下单时间',
  `review_time` datetime DEFAULT NULL COMMENT '审核时间',
  `use_time` int(20) DEFAULT NULL COMMENT '使用时长（/时）',
  `payment_method` tinyint(2) DEFAULT NULL COMMENT '状态 1:余额;2:微信;3:支付宝',
  `payment_time` datetime DEFAULT NULL COMMENT '支付时间',
  `start_time` datetime DEFAULT NULL COMMENT '开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '结束时间',
  `pick_up_code` varchar(64) DEFAULT NULL COMMENT '取车码',
  `return_code` varchar(64) DEFAULT NULL COMMENT '还车码',
  `confirm_pick_up_car` tinyint(2) DEFAULT '0' COMMENT '确认取车 1:未确认取车;2:已确认取车;',
  `confirm_return_car` tinyint(2) DEFAULT '0' COMMENT '确认还车 1:未确认还车;2:已确认还车;',
  `pick_up_time` datetime DEFAULT NULL COMMENT '取车时间',
  `return_time` datetime DEFAULT NULL COMMENT '还车时间',
  `pick_up_face_recognition` varchar(255) DEFAULT NULL COMMENT '取车人脸识别',
  `return_face_recognition` varchar(255) DEFAULT NULL COMMENT '还车人脸识别',
  `pick_up_photo` varchar(1000) DEFAULT NULL COMMENT '取车照',
  `return_photo` varchar(1000) DEFAULT NULL COMMENT '还车照',
  `scratch` tinyint(2) DEFAULT '0' COMMENT '车身有无刮伤 1:有;2:无;',
  `health` tinyint(2) DEFAULT '0' COMMENT '车内卫生是否整洁 1:是;2:否;',
  `lease_order_overtime` int(5) DEFAULT NULL COMMENT '未付款时自动取消时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='汽车订单';

DROP TABLE IF EXISTS `oshare_device`;
CREATE TABLE `oshare_device` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `publisher_id` int(11) DEFAULT '0' COMMENT '发布人',
  `numbering` varchar(50) DEFAULT NULL COMMENT '设备编号',
  `mac` varchar(50) DEFAULT NULL COMMENT '设备mac',
  `name` varchar(50) DEFAULT NULL COMMENT '设备名称',
  `product_id` int(20) DEFAULT NULL COMMENT '所属产品',
  `drop_site_id` int(20) DEFAULT NULL COMMENT '站点ID',
  `online_status` tinyint(2) DEFAULT '1' COMMENT '在线状态 1:新增 2:在线 3:离线',
  `location` varchar(50) DEFAULT NULL COMMENT '设备地点',
  `detailed_location` varchar(255) DEFAULT NULL COMMENT '详细地点',
  `longitude` varchar(100) DEFAULT NULL COMMENT '经度',
  `latitude` varchar(100) DEFAULT NULL COMMENT '纬度',
  `pic` varchar(255) DEFAULT NULL COMMENT '图片',
  `lease_status` tinyint(2) DEFAULT NULL COMMENT '租赁状态 1:可租用 2:不可租',
  `hourly_price` decimal(10,2) DEFAULT NULL COMMENT '时租价格',
  `day_cap` decimal(10,2) DEFAULT NULL COMMENT '当日封顶',
  `start_time` varchar(30) DEFAULT NULL COMMENT '共享开始时间',
  `end_time` varchar(30) DEFAULT NULL COMMENT '共享结束时间',
  `qr_code` varchar(255) DEFAULT NULL COMMENT '设备二维码',
  `online_time` datetime DEFAULT NULL COMMENT '上线时间',
  `introduction` text COMMENT '介绍',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='设备管理';

DROP TABLE IF EXISTS `oshare_device_order`;
CREATE TABLE `oshare_device_order` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_number` varchar(64) DEFAULT NULL COMMENT '订单号',
  `user_id` int(20) DEFAULT NULL COMMENT '租户',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态 1:待审核;2:待支付;3:待取货;4:待归还;5:归还审核;6:已完成;7:已取消',
  `device_id` int(20) DEFAULT NULL COMMENT '设备',
  `drop_site_id` int(20) DEFAULT NULL COMMENT '所属站点',
  `deposit` decimal(10,2) DEFAULT NULL COMMENT '押金',
  `order_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单金额',
  `order_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '下单时间',
  `review_time` datetime DEFAULT NULL COMMENT '审核时间',
  `use_time` int(20) DEFAULT NULL COMMENT '使用时长（/分）',
  `payment_method` tinyint(2) DEFAULT NULL COMMENT '支付方式 1:余额;2:微信;3:支付宝',
  `payment_time` datetime DEFAULT NULL COMMENT '支付时间',
  `start_time` datetime DEFAULT NULL COMMENT '开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '结束时间',
  `rent_audit_time` datetime DEFAULT NULL COMMENT '租赁审核时间',
  `postscript` varchar(255) DEFAULT NULL COMMENT '用户附言',
  `return_time` datetime DEFAULT NULL COMMENT '归还时间',
  `breach` tinyint(2) DEFAULT NULL COMMENT '是否有违约 1:是 2:否',
  `breach_content` varchar(255) DEFAULT NULL COMMENT '违约内容',
  `is_deduction_deposit` tinyint(2) DEFAULT NULL COMMENT '是否扣除押金 1:是 2:否',
  `deduction_deposit` decimal(10,2) DEFAULT NULL COMMENT '扣除金额',
  `return_audit_time` datetime DEFAULT NULL COMMENT '归还时间',
  `lease_order_overtime` int(5) DEFAULT NULL COMMENT '未付款时自动取消时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='设备订单';

DROP TABLE IF EXISTS `pshare_after_sale_order_e`;
CREATE TABLE `pshare_after_sale_order_e` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_id` int(20) NOT NULL COMMENT '订单ID',
  `praise` int(1) DEFAULT NULL COMMENT '评分',
  `rate` int(1) DEFAULT NULL COMMENT '完成率',
  `evaluation_user` tinyint(2) NOT NULL COMMENT '评价人 1企业 2接单人',
  `evaluation` varchar(255) NOT NULL COMMENT '评价内容',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态 1显示 2不显示',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='共享售后评价表';

DROP TABLE IF EXISTS `oshare_pshare_carousel`;
CREATE TABLE `oshare_pshare_carousel` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `type` tinyint(2) DEFAULT NULL COMMENT '类型 1:物共享 2:人共享',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态 1:可用 2:禁用',
  `sort` int(11) NOT NULL COMMENT '排序',
  `pic` varchar(255) DEFAULT NULL COMMENT '图片地址',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='物共享人共享轮播图';

DROP TABLE IF EXISTS `message_center`;
CREATE TABLE `message_center` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `title` varchar(64) DEFAULT NULL COMMENT '标题',
  `content` varchar(255) DEFAULT NULL COMMENT '内容',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1、未读;2、已读]',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='消息中心';

DROP TABLE IF EXISTS `sys_setting`;
CREATE TABLE `sys_setting` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `lease_order_overtime` int(5) DEFAULT NULL COMMENT '租赁订单超过多少天自动取消',
  `pshare_order_overtime` int(5) DEFAULT NULL COMMENT '人共享订单超过多少天自动付款',
  `pshare_order_delaytime` int(5) DEFAULT NULL COMMENT '人共享订单增加付款时间',
  `evaluation_status` tinyint(2) DEFAULT NULL COMMENT '评价显示 1:开启;2:关闭',
  `platform_distribution` decimal(10,2) DEFAULT '0.00' COMMENT '平台分润',
  `super_salesman_split` decimal(10,2) DEFAULT '0.00' COMMENT '上级业务员分润',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='系统设置';

DROP TABLE IF EXISTS `oshare_device_repair`;
CREATE TABLE `oshare_device_repair` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_id` int(20) DEFAULT NULL COMMENT '订单ID',
  `device_id` int(20) DEFAULT NULL COMMENT '设备ID',
  `user_id` int(20) DEFAULT NULL COMMENT '报修人',
  `phone` varchar(30) DEFAULT NULL COMMENT '联系电话',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态 1:处理中;2:已处理;3:已更换;',
  `annex` text COMMENT '报修附件',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '报修时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='设备报修';

DROP TABLE IF EXISTS `protocol`;
CREATE TABLE `protocol` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `title` varchar(25) DEFAULT NULL COMMENT '标题',
  `content` text COMMENT '内容',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='协议表';

DROP TABLE IF EXISTS `user_device`;
CREATE TABLE `user_device` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) DEFAULT NULL COMMENT '用户ID',
  `device_id` int(11) DEFAULT NULL COMMENT '设备ID',
  `status` tinyint(2) DEFAULT NULL COMMENT '状态 1:有效;2:无效;',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户设备关联表';

DROP TABLE IF EXISTS `pshare_timing_order_t`;
CREATE TABLE `pshare_timing_order_t` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `publisher_id` int(20) DEFAULT NULL COMMENT '发布人ID',
  `business` varchar(20) DEFAULT NULL COMMENT '商家',
  `title` varchar(64) DEFAULT NULL COMMENT '标题',
  `service_area` varchar(20) DEFAULT NULL COMMENT '服务区域',
  `order_deposit` decimal(10,2) DEFAULT '0.00' COMMENT '接单押金',
  `order_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单金额',
  `work_start_time` varchar(20) DEFAULT NULL COMMENT '工作开始时间',
  `work_end_time` varchar(20) DEFAULT NULL COMMENT '工作结束时间',
  `work_place` varchar(100) DEFAULT NULL COMMENT '工作地点',
  `job_name` varchar(20) DEFAULT NULL COMMENT '工作名称',
  `hourly_wage` decimal(10,2) DEFAULT NULL COMMENT '计时工资',
  `required_quantity` decimal(10,2) DEFAULT NULL COMMENT '完成数量要求',
  `completion_time_requirements` decimal(10,2) DEFAULT NULL COMMENT '完成时间要求',
  `pass_rate` decimal(10,2) DEFAULT NULL COMMENT '合格品率',
  `defective_rate` decimal(10,2) DEFAULT NULL COMMENT '次品率',
  `rejection_rate` decimal(10,2) DEFAULT NULL COMMENT '废品率',
  `work_content` varchar(255) DEFAULT NULL COMMENT '工作内容',
  `work_content_pic` text COMMENT '工作内容图片',
  `examination_content` varchar(255) DEFAULT NULL COMMENT '考核内容',
  `bonus_system` varchar(255) DEFAULT NULL COMMENT '奖励机制',
  `penalties` varchar(255) DEFAULT NULL COMMENT '处罚机制',
  `job_requirements` varchar(255) DEFAULT NULL COMMENT '岗位要求',
  `company_name` varchar(50) DEFAULT NULL COMMENT '企业名称',
  `business_registration_number` varchar(100) DEFAULT NULL COMMENT '营业注册号',
  `company_address` varchar(64) DEFAULT NULL COMMENT '企业地址',
  `contact_number` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `contact_person` varchar(20) DEFAULT NULL COMMENT '联系人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='人共享计时订单模板';

DROP TABLE IF EXISTS `pshare_piece_order_t`;
CREATE TABLE `pshare_piece_order_t` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `publisher_id` int(20) DEFAULT NULL COMMENT '发布人ID',
  `business` varchar(20) DEFAULT NULL COMMENT '商家',
  `title` varchar(64) DEFAULT NULL COMMENT '标题',
  `service_area` varchar(20) DEFAULT NULL COMMENT '服务区域',
  `order_deposit` decimal(10,2) DEFAULT '0.00' COMMENT '接单押金',
  `order_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单金额',
  `work_start_time` varchar(20) DEFAULT NULL COMMENT '工作开始时间',
  `work_end_time` varchar(20) DEFAULT NULL COMMENT '工作结束时间',
  `work_place` varchar(100) DEFAULT NULL COMMENT '工作地点',
  `job_name` varchar(20) DEFAULT NULL COMMENT '工作名称',
  `piece_rate` decimal(10,2) DEFAULT NULL COMMENT '计时工资',
  `required_quantity` decimal(10,2) DEFAULT NULL COMMENT '完成数量要求',
  `completion_time_requirements` decimal(10,2) DEFAULT NULL COMMENT '完成时间要求',
   `pass_quantity` int(10) DEFAULT NULL COMMENT '合格数量要求',
  `defectives_quantity` int(10) DEFAULT NULL COMMENT '次品数量要求',
  `rejection_quantity` int(10) DEFAULT NULL COMMENT '废品数量要求',
  `pass_rate` decimal(10,2) DEFAULT NULL COMMENT '合格品率',
  `defective_rate` decimal(10,2) DEFAULT NULL COMMENT '次品率',
  `rejection_rate` decimal(10,2) DEFAULT NULL COMMENT '废品率',
  `work_content` varchar(255) DEFAULT NULL COMMENT '工作内容',
  `work_content_pic` text COMMENT '工作内容图片',
  `examination_content` varchar(255) DEFAULT NULL COMMENT '考核内容',
  `bonus_system` varchar(255) DEFAULT NULL COMMENT '奖励机制',
  `penalties` varchar(255) DEFAULT NULL COMMENT '处罚机制',
  `job_requirements` varchar(255) DEFAULT NULL COMMENT '岗位要求',
  `company_name` varchar(50) DEFAULT NULL COMMENT '企业名称',
  `business_registration_number` varchar(100) DEFAULT NULL COMMENT '营业注册号',
  `company_address` varchar(64) DEFAULT NULL COMMENT '企业地址',
  `contact_number` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `contact_person` varchar(20) DEFAULT NULL COMMENT '联系人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享计件订单模板';


DROP TABLE IF EXISTS `pshare_business_order_e`;
CREATE TABLE `pshare_business_order_e` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_id` int(20) NOT NULL COMMENT '订单ID',
  `praise` int(1) DEFAULT NULL COMMENT '评分',
  `rate` int(1) DEFAULT NULL COMMENT '完成率',
  `evaluation_user` tinyint(2) NOT NULL COMMENT '评价人 1企业 2接单人',
  `evaluation` varchar(255) NOT NULL COMMENT '评价内容',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态 1显示 2不显示',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='共享业务评价表';

DROP TABLE IF EXISTS `pshare_timing_order_e`;
CREATE TABLE `pshare_timing_order_e` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_id` int(20) NOT NULL COMMENT '订单ID',
  `praise` int(1) DEFAULT NULL COMMENT '评分',
  `rate` int(1) DEFAULT NULL COMMENT '完成率',
  `evaluation_user` tinyint(2) NOT NULL COMMENT '评价人 1企业 2接单人',
  `evaluation` varchar(255) NOT NULL COMMENT '评价内容',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态 1显示 2不显示',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='共享计时评价表';

DROP TABLE IF EXISTS `pshare_piece_order_e`;
CREATE TABLE `pshare_piece_order_e` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_id` int(20) NOT NULL COMMENT '订单ID',
  `praise` int(1) DEFAULT NULL COMMENT '评分',
  `rate` int(1) DEFAULT NULL COMMENT '完成率',
  `evaluation_user` tinyint(2) NOT NULL COMMENT '评价人 1企业 2接单人',
  `evaluation` varchar(255) NOT NULL COMMENT '评价内容',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态 1显示 2不显示',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='共享计件评价表';

DROP TABLE IF EXISTS `pshare_business_order_distribution`;
CREATE TABLE `pshare_business_order_distribution` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `order_id` int(11) NOT NULL COMMENT '订单ID',
  `contract_id` int(11) NOT NULL COMMENT '合同ID',
  `remark` varchar(64) DEFAULT NULL COMMENT '备注',
  `url` varchar(255) DEFAULT NULL COMMENT '图片地址',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='分销店凭证';

DROP TABLE IF EXISTS `pshare_business_order_agency`;
CREATE TABLE `pshare_business_order_agency` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `order_id` int(11) NOT NULL COMMENT '订单ID',
  `contract_id` int(11) NOT NULL COMMENT '合同ID',
  `remark` varchar(64) DEFAULT NULL COMMENT '备注',
  `url` varchar(255) DEFAULT NULL COMMENT '图片地址',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='代理店凭证';

DROP TABLE IF EXISTS `pshare_business_order_transaction`;
CREATE TABLE `pshare_business_order_transaction` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `order_id` int(11) NOT NULL COMMENT '订单ID',
  `contract_id` int(11) NOT NULL COMMENT '合同ID',
  `remark` varchar(64) DEFAULT NULL COMMENT '备注',
  `url` varchar(255) DEFAULT NULL COMMENT '图片地址',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='交易凭证';

DROP TABLE IF EXISTS `pshare_contract`;
CREATE TABLE `pshare_contract` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `title` varchar(64) DEFAULT NULL COMMENT '标题',
  `content` text COMMENT '内容',
  `type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '类型[1有效分销店;2有效代理店;3有效交易]',
  `is_default` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否为默认 1、是 2、不是',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='共享业务合同';

DROP TABLE IF EXISTS `withdraw`;
CREATE TABLE `withdraw` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `order_number` varchar(64) DEFAULT NULL COMMENT '订单号',
  `user_id` int(11) NOT NULL COMMENT '提现用户',
  `type` tinyint(2) DEFAULT '1' COMMENT '提现类型[1:余额 2:保障金]',
  `success_time` datetime DEFAULT NULL COMMENT '提现成功时间',
  `amount` decimal(10,2) DEFAULT '0.00' COMMENT '提现金额',
  `withdraw_after_amount` decimal(10,2) DEFAULT '0.00' COMMENT '提现后的金额',
  `bank` varchar(64) DEFAULT NULL COMMENT '提现银行',
  `bank_card_no` varchar(64) DEFAULT NULL COMMENT '银行卡号',
  `name` varchar(64) DEFAULT NULL COMMENT '持卡人姓名',
  `branch` varchar(64) DEFAULT NULL COMMENT '开户支行',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `status` tinyint(2) DEFAULT '1' COMMENT '[1、提现处理中；2、提现申请失败；3、提现申请成功；4、用户撤销]',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户提现信息表';

DROP TABLE IF EXISTS `pshare_business_order_rt`;
CREATE TABLE `pshare_business_order_rt` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
	`order_id` int(11) NOT NULL COMMENT '订单ID',
  `file_name` varchar(64) DEFAULT NULL COMMENT '文件名',
  `url` varchar(255) DEFAULT NULL COMMENT '文件地址',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='共享业务接单人上传模板';

DROP TABLE IF EXISTS `recharge`;
CREATE TABLE `recharge` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `order_number` varchar(64) DEFAULT NULL COMMENT '订单号',
  `user_id` int(11) NOT NULL COMMENT '提现用户',
  `pay_type` tinyint(2) DEFAULT '1' COMMENT '支付方式[1:微信支付 2:支付宝]',
  `recharge_type` tinyint(2) DEFAULT '1' COMMENT '充值类型 1、余额充值  2、保障金充值',
  `order_amount` decimal(10,2) DEFAULT '0.00' COMMENT '充值金额',
  `recharge_after_amount` decimal(10,2) DEFAULT '0.00' COMMENT '充值后金额',
  `pay_time` datetime DEFAULT NULL COMMENT '付款时间',
  `cancel_time` datetime DEFAULT NULL COMMENT '取消时间',
  `out_trade_no` varchar(255) DEFAULT NULL COMMENT '商户订单号',
  `trade_no` varchar(255) DEFAULT NULL COMMENT '支付平台交易号',
  `status` tinyint(2) DEFAULT '1' COMMENT '订单状态[1、待付款；2、已取消；3、已作废；4、已完成；]',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户充值信息表';


CREATE TABLE `basic_auth_personal` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真是姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
  `address` varchar(255) DEFAULT NULL COMMENT '详细地址',
  `idcard_front`  varchar(255) DEFAULT NULL COMMENT '身份证正面',
  `idcard_reverse`  varchar(255) DEFAULT NULL COMMENT '身份证反面',
  `face_recognition`  varchar(255) DEFAULT NULL COMMENT '人脸识别',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `basic_auth_personal_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='基础认证-个人认证';

CREATE TABLE `basic_auth_business` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `business_name` varchar(50) DEFAULT NULL COMMENT '公司名称',
  `register_no` varchar(50) DEFAULT NULL COMMENT '注册号',
  `legal_name` varchar(20) DEFAULT NULL COMMENT '法定代表人',
  `legal_idcard_type` tinyint(2) DEFAULT NULL COMMENT '法人证件类型 1身份证2其他',
  `legal_idcard_no` varchar(50) DEFAULT NULL COMMENT '法人证件号码',
  `legal_idcard_img` varchar(255) DEFAULT NULL COMMENT '法人身份证电子版',
  `register_addr` varchar(255) DEFAULT NULL COMMENT '公司注册地',
  `business_term` varchar(10) DEFAULT NULL COMMENT '营业期限',
  `registered_capital` varchar(10) DEFAULT NULL COMMENT '注册资本',
  `business_img` varchar(255) DEFAULT NULL COMMENT '公司营业执照',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `address` varchar(55) DEFAULT NULL COMMENT '公司详细地址',
  `contact` varchar(20) DEFAULT NULL COMMENT '联系人',
  `contact_tel` varchar(30) DEFAULT NULL COMMENT '联系电话',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `basic_auth_business_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='基础认证-商家认证';

CREATE TABLE `filter_auth_owner` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真是姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
	`address` varchar(255) DEFAULT NULL COMMENT '详细地址',
	`idcard_front`  varchar(255) DEFAULT NULL COMMENT '身份证正面',
	`idcard_reverse`  varchar(255) DEFAULT NULL COMMENT '身份证反面',
	`face_recognition`  varchar(255) DEFAULT NULL COMMENT '人脸识别',
	`holding_documents`  varchar(255) DEFAULT NULL COMMENT '持有证据',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `filter_auth_owner_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='净化器认证-所有者';


CREATE TABLE `car_auth_owner` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真是姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
  `idcard_front`  varchar(255) DEFAULT NULL COMMENT '身份证正面',
  `idcard_reverse`  varchar(255) DEFAULT NULL COMMENT '身份证反面',
  `driving_license` varchar(255) DEFAULT NULL COMMENT '行驶证正本',
  `driving_license_copy` varchar(255) DEFAULT NULL COMMENT '行驶证副本',
  `face_recognition`  varchar(255) DEFAULT NULL COMMENT '人脸识别',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `car_auth_owner_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='汽车认证-所有者';


CREATE TABLE `car_auth_owner_c` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `car_auth_owner_id` int(11) NOT NULL COMMENT '认证id',
   `numbering` varchar(50) DEFAULT NULL COMMENT '设备编号',
  `vehicle_brands` varchar(20) DEFAULT NULL COMMENT '车辆品牌',
  `vehicle_model` varchar(20) DEFAULT NULL COMMENT '车辆型号',
  `vehicle_license_plate_number` varchar(20) DEFAULT NULL COMMENT '车辆车牌号',
  `vehicle_annual_inspection_time` varchar(20) DEFAULT NULL COMMENT '车辆年检时间',
  `insurance_start_time` varchar(30) DEFAULT NULL COMMENT '保险开始时间',
  `insurance_end_time` varchar(30) DEFAULT NULL COMMENT '保险结束时间',
  `gear_type` tinyint(2) NOT NULL DEFAULT '0' COMMENT '档位类型 1自动挡 2手动档',
  `number_of_seats` int(11) NOT NULL COMMENT '座位数量',
  `driving_license` varchar(255) DEFAULT NULL COMMENT '行驶证正本',
  `driving_license_copy` varchar(255) DEFAULT NULL COMMENT '行驶证副本',
  `shared` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否共享 1：未共享 2：已共享',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `insurance_pic` text COMMENT '保险图片',
  `car_pic` varchar(255) DEFAULT NULL COMMENT '汽车图片',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='汽车认证-所有者-汽车内容';



CREATE TABLE `parking_auth_owner` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真是姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
  `address` varchar(255) DEFAULT NULL COMMENT '详细地址',
  `phone` varchar(255) DEFAULT NULL COMMENT '联系电话',
  `idcard_front`  varchar(255) DEFAULT NULL COMMENT '身份证正面',
  `idcard_reverse`  varchar(255) DEFAULT NULL COMMENT '身份证反面',
  `face_recognition`  varchar(255) DEFAULT NULL COMMENT '人脸识别',
  `holding_idcard`  varchar(255) DEFAULT NULL COMMENT '手持身份证',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `parking_auth_owner_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='车位认证-所有者';

CREATE TABLE `filter_auth_orderer` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真是姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
	`address` varchar(255) DEFAULT NULL COMMENT '详细地址',
	`idcard_front`  varchar(255) DEFAULT NULL COMMENT '身份证正面',
	`idcard_reverse`  varchar(255) DEFAULT NULL COMMENT '身份证反面',
	`face_recognition`  varchar(255) DEFAULT NULL COMMENT '人脸识别',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `filter_auth_orderer_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='净化器认证-接单人';


CREATE TABLE `car_auth_orderer` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真是姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
	`idcard_front`  varchar(255) DEFAULT NULL COMMENT '身份证正面',
	`idcard_reverse`  varchar(255) DEFAULT NULL COMMENT '身份证反面',
	`driver_license_original_photo` varchar(255) DEFAULT NULL COMMENT '驾驶证正本',
  `driver_license_copy_photo` varchar(255) DEFAULT NULL COMMENT '驾驶证副本',
	`face_recognition`  varchar(255) DEFAULT NULL COMMENT '人脸识别',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `car_auth_orderer_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='租车认证-接单人';


CREATE TABLE `parking_auth_orderer` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真是姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
	`address` varchar(255) DEFAULT NULL COMMENT '详细地址',
	`idcard_front`  varchar(255) DEFAULT NULL COMMENT '身份证正面',
	`idcard_reverse`  varchar(255) DEFAULT NULL COMMENT '身份证反面',
	`face_recognition`  varchar(255) DEFAULT NULL COMMENT '人脸识别',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `parking_auth_orderer_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='车位租用认证-接单人';


CREATE TABLE `timing_auth_business` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `business_name` varchar(50) DEFAULT NULL COMMENT '公司名称',
  `register_no` varchar(50) DEFAULT NULL COMMENT '注册号',
  `legal_name` varchar(20) DEFAULT NULL COMMENT '法定代表人',
  `legal_idcard_type` tinyint(2) DEFAULT NULL COMMENT '法人证件类型 1身份证2其他',
  `legal_idcard_no` varchar(50) DEFAULT NULL COMMENT '法人证件号码',
  `legal_idcard_img` varchar(255) DEFAULT NULL COMMENT '法人身份证电子版',
  `register_addr` varchar(255) DEFAULT NULL COMMENT '公司注册地',
  `business_term` varchar(10) DEFAULT NULL COMMENT '营业期限',
  `registered_capital` varchar(10) DEFAULT NULL COMMENT '注册资本',
  `business_img` varchar(255) DEFAULT NULL COMMENT '公司营业执照',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `address` varchar(55) DEFAULT NULL COMMENT '公司详细地址',
  `contact` varchar(20) DEFAULT NULL COMMENT '联系人',
  `contact_tel` varchar(30) DEFAULT NULL COMMENT '联系电话',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `timing_auth_business_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='计时工认证-商家认证';

CREATE TABLE `piece_auth_business` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `business_name` varchar(50) DEFAULT NULL COMMENT '公司名称',
  `register_no` varchar(50) DEFAULT NULL COMMENT '注册号',
  `legal_name` varchar(20) DEFAULT NULL COMMENT '法定代表人',
  `legal_idcard_type` tinyint(2) DEFAULT NULL COMMENT '法人证件类型 1身份证2其他',
  `legal_idcard_no` varchar(50) DEFAULT NULL COMMENT '法人证件号码',
  `legal_idcard_img` varchar(255) DEFAULT NULL COMMENT '法人身份证电子版',
  `register_addr` varchar(255) DEFAULT NULL COMMENT '公司注册地',
  `business_term` varchar(10) DEFAULT NULL COMMENT '营业期限',
  `registered_capital` varchar(10) DEFAULT NULL COMMENT '注册资本',
  `business_img` varchar(255) DEFAULT NULL COMMENT '公司营业执照',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `address` varchar(55) DEFAULT NULL COMMENT '公司详细地址',
  `contact` varchar(20) DEFAULT NULL COMMENT '联系人',
  `contact_tel` varchar(30) DEFAULT NULL COMMENT '联系电话',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `piece_auth_business_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='计件工认证-商家认证';

CREATE TABLE `after_auth_business` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `business_name` varchar(50) DEFAULT NULL COMMENT '公司名称',
  `register_no` varchar(50) DEFAULT NULL COMMENT '注册号',
  `legal_name` varchar(20) DEFAULT NULL COMMENT '法定代表人',
  `legal_idcard_type` tinyint(2) DEFAULT NULL COMMENT '法人证件类型 1身份证2其他',
  `legal_idcard_no` varchar(50) DEFAULT NULL COMMENT '法人证件号码',
  `legal_idcard_img` varchar(255) DEFAULT NULL COMMENT '法人身份证电子版',
  `register_addr` varchar(255) DEFAULT NULL COMMENT '公司注册地',
  `business_term` varchar(10) DEFAULT NULL COMMENT '营业期限',
  `registered_capital` varchar(10) DEFAULT NULL COMMENT '注册资本',
  `business_img` varchar(255) DEFAULT NULL COMMENT '公司营业执照',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `address` varchar(55) DEFAULT NULL COMMENT '公司详细地址',
  `contact` varchar(20) DEFAULT NULL COMMENT '联系人',
  `contact_tel` varchar(30) DEFAULT NULL COMMENT '联系电话',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `after_auth_business_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='售后认证-商家认证';

CREATE TABLE `business_auth_business` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `business_name` varchar(50) DEFAULT NULL COMMENT '公司名称',
  `register_no` varchar(50) DEFAULT NULL COMMENT '注册号',
  `legal_name` varchar(20) DEFAULT NULL COMMENT '法定代表人',
  `legal_idcard_type` tinyint(2) DEFAULT NULL COMMENT '法人证件类型 1身份证2其他',
  `legal_idcard_no` varchar(50) DEFAULT NULL COMMENT '法人证件号码',
  `legal_idcard_img` varchar(255) DEFAULT NULL COMMENT '法人身份证电子版',
  `register_addr` varchar(255) DEFAULT NULL COMMENT '公司注册地',
  `business_term` varchar(10) DEFAULT NULL COMMENT '营业期限',
  `registered_capital` varchar(10) DEFAULT NULL COMMENT '注册资本',
  `business_img` varchar(255) DEFAULT NULL COMMENT '公司营业执照',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `address` varchar(55) DEFAULT NULL COMMENT '公司详细地址',
  `contact` varchar(20) DEFAULT NULL COMMENT '联系人',
  `contact_tel` varchar(30) DEFAULT NULL COMMENT '联系电话',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `after_auth_business_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='业务认证-商家认证';

CREATE TABLE `timing_auth_orderer` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真是姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
  `sex` tinyint(2) NOT NULL DEFAULT '1' COMMENT '性别 1男 2女',
  `major` varchar(55) DEFAULT NULL COMMENT '专业',
  `service_area` varchar(55) DEFAULT NULL COMMENT '服务区',
  `address` varchar(55) DEFAULT NULL COMMENT '详细地址',
  `holding_id_card` varchar(255) DEFAULT NULL COMMENT '手持身份证',
  `default_harvest_address` varchar(255) DEFAULT NULL COMMENT '默认收获地址',
  `contacts` varchar(10) DEFAULT NULL COMMENT '联系人',
  `contact_number` varchar(30) DEFAULT NULL COMMENT '联系电话',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `timing_auth_orderer_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='计时工认证-接单人';

CREATE TABLE `piece_auth_orderer` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真是姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
  `sex` tinyint(2) NOT NULL DEFAULT '1' COMMENT '性别 1男 2女',
  `major` varchar(55) DEFAULT NULL COMMENT '专业',
  `service_area` varchar(55) DEFAULT NULL COMMENT '服务区',
  `address` varchar(55) DEFAULT NULL COMMENT '详细地址',
  `holding_id_card` varchar(255) DEFAULT NULL COMMENT '手持身份证',
  `default_harvest_address` varchar(255) DEFAULT NULL COMMENT '默认收获地址',
  `contacts` varchar(10) DEFAULT NULL COMMENT '联系人',
  `contact_number` varchar(30) DEFAULT NULL COMMENT '联系电话',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `piece_auth_orderer_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='计件工认证-接单人';

CREATE TABLE `after_auth_orderer` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真是姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
  `sex` tinyint(2) NOT NULL DEFAULT '1' COMMENT '性别 1男 2女',
  `major` varchar(55) DEFAULT NULL COMMENT '专业',
  `service_area` varchar(55) DEFAULT NULL COMMENT '服务区',
  `address` varchar(55) DEFAULT NULL COMMENT '详细地址',
  `holding_id_card` varchar(255) DEFAULT NULL COMMENT '手持身份证',
  `default_harvest_address` varchar(255) DEFAULT NULL COMMENT '默认收获地址',
  `contacts` varchar(10) DEFAULT NULL COMMENT '联系人',
  `contact_number` varchar(30) DEFAULT NULL COMMENT '联系电话',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `after_auth_orderer_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='售后认证-接单人';

CREATE TABLE `business_auth_orderer` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真是姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
  `sex` tinyint(2) NOT NULL DEFAULT '1' COMMENT '性别 1男 2女',
  `major` varchar(55) DEFAULT NULL COMMENT '专业',
  `service_area` varchar(55) DEFAULT NULL COMMENT '服务区',
  `address` varchar(55) DEFAULT NULL COMMENT '详细地址',
  `holding_id_card` varchar(255) DEFAULT NULL COMMENT '手持身份证',
  `default_harvest_address` varchar(255) DEFAULT NULL COMMENT '默认收获地址',
  `contacts` varchar(10) DEFAULT NULL COMMENT '联系人',
  `contact_number` varchar(30) DEFAULT NULL COMMENT '联系电话',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `business_auth_orderer_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='业务认证-接单人';

CREATE TABLE `version_management` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `version_number` varchar(64) DEFAULT NULL COMMENT '版本号',
  `version_name` varchar(64) DEFAULT NULL COMMENT '版本名称',
  `download_link` varchar(255) DEFAULT NULL COMMENT '版本名称',
  `content` varchar(255) DEFAULT NULL COMMENT '升级内容',
  `force_upgrade` tinyint(2) DEFAULT NULL COMMENT '是否强制升级 1是 2否',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='版本管理';

CREATE TABLE `instruction_parsing` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `product_id` int(20) DEFAULT NULL COMMENT '所属产品',
  `name` varchar(10) DEFAULT NULL COMMENT '名称',
  `length` int(11) NOT NULL COMMENT '长度',
  `type` tinyint(2) DEFAULT '1' COMMENT '类型[1整数;2字符串;]',
  `sort` int(11) NOT NULL COMMENT '排序',
  `cmd` varchar(50) DEFAULT NULL COMMENT '指令',
  `note` varchar(50) DEFAULT NULL COMMENT '备注',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `instruction_parsing_product_id` (`product_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='指令解析';

CREATE TABLE `oshare_device_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `device_id` int(20) NOT NULL COMMENT '设备ID',
  `name` varchar(10) NOT NULL COMMENT '名称',
  `value` varchar(10) NOT NULL COMMENT '值',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `oshare_device_data_device_id` (`device_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='设备数据';


CREATE TABLE `oshare_divided` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_id` int(20) DEFAULT NULL COMMENT '订单ID',
  `order_type` tinyint(2) DEFAULT NULL COMMENT '订单类型 1：设备分润 2：汽车分润 3：车位分润',
  `user_id` int(20) DEFAULT '0' COMMENT '分润用户',
  `divided_type` tinyint(2) DEFAULT NULL COMMENT '分润类型 1：平台分润 2：业务员分润 3：上级业务员分润 4：共享者分润 5：站点分润',
  `divided_amount` decimal(10,2) DEFAULT NULL COMMENT '分润金额',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='分润记录表';


CREATE TABLE `oshare_product_divided` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `product_id` int(20) NOT NULL COMMENT '产品ID',
  `platform_distribution` decimal(10,3) DEFAULT NULL COMMENT '平台分润',
  `salesman_split` decimal(10,3) DEFAULT NULL COMMENT '业务员分润',
  `salesman_user_id` int(20) DEFAULT NULL COMMENT '业务员ID',
  `super_salesman_split` decimal(10,3) DEFAULT NULL COMMENT '上级业务员分润',
  `sharer_split` decimal(10,3) DEFAULT NULL COMMENT '共享者分润',
  `site_split` decimal(10,3) DEFAULT NULL COMMENT '站点分润',
  `founder` int(20) NOT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `productId` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='产品分润';


alter table oshare_car_order add whether_timeout  tinyint(2) DEFAULT '1' COMMENT '是否超时 1否 2时';

alter table oshare_car_order add `overtime_pay` tinyint(2) DEFAULT '0' COMMENT '超时付款 1未付款 2已付款';

alter table oshare_car_order add `early_entry_amount` decimal(10,2) DEFAULT '0.00' COMMENT '提前进门金额';

alter table oshare_car_order add `overtime` int(10) DEFAULT '0' COMMENT '超时时间';

alter table oshare_parking_space_order add  `confirm_entry` tinyint(2) DEFAULT '0' COMMENT '确认进门 1:未确认进门;2:已确认进门;';
alter table oshare_parking_space_order add  `confirm_exit` tinyint(2) DEFAULT '0' COMMENT '确认出门 1:未确认出门;2:已确认出门;';

alter table oshare_parking_space_order add  `early_entry_amount` decimal(10,2) DEFAULT '0.00' COMMENT '提前进门金额' after overtime_pay;
alter table oshare_parking_space_order add  `overtime` int(10) DEFAULT '0' COMMENT '超时时间'  after early_entry_amount;

alter table oshare_device add  `reason` varchar(255) DEFAULT NULL COMMENT '设备二维码' after introduction;

alter table oshare_car_order add  `service_fee` tinyint(2) DEFAULT '1' COMMENT '是否需要服务费 1否 2是';

alter table oshare_parking_space_order add  `service_fee` tinyint(2) DEFAULT '1' COMMENT '是否需要服务费 1否 2是';

alter table oshare_device_order add  `service_fee` tinyint(2) DEFAULT '1' COMMENT '是否需要服务费 1否 2是';

alter table pshare_after_sale_order add  `chargeback_time` datetime DEFAULT NULL COMMENT '申请退单时间';
alter table pshare_business_order add  `chargeback_time` datetime DEFAULT NULL COMMENT '申请退单时间';
alter table pshare_piece_order add  `chargeback_time` datetime DEFAULT NULL COMMENT '申请退单时间';
alter table pshare_timing_order add  `chargeback_time` datetime DEFAULT NULL COMMENT '申请退单时间';

alter table oshare_device add `numbering_flag`  varchar(50) DEFAULT NULL COMMENT '编号标识'  after numbering;

alter table oshare_parking_space add `product_id`  int(11) DEFAULT NULL COMMENT '所属产品'  after publisher_id;
alter table oshare_car add `product_id`  int(11) DEFAULT NULL COMMENT '所属产品'  after publisher_id;

alter table oshare_device add `hourly_price`  decimal(10,2) DEFAULT NULL COMMENT '时租价格'  after lease_status;
alter table oshare_device add `day_cap`  decimal(10,2) DEFAULT NULL COMMENT '当日封顶'  after hourly_price;
alter table oshare_device add `start_time`  varchar(30) DEFAULT NULL COMMENT '共享开始时间'  after day_cap;
alter table oshare_device add `end_time`  varchar(30) DEFAULT NULL COMMENT '共享结束时间'  after start_time;

alter table oshare_device_order add `confirm_pick_up` tinyint(2) DEFAULT '0' COMMENT '确认取货 1:未确认取货;2:已确认取货;';
alter table oshare_device_order add `confirm_return` tinyint(2) DEFAULT '0' COMMENT '确认归还 1:未确认归还;2:已确认归还;';
alter table oshare_device_order add `pick_up_code` varchar(64) DEFAULT NULL COMMENT '取货码';
alter table oshare_device_order add `return_code` varchar(64) DEFAULT NULL COMMENT '还货码';

--0316
alter table oshare_device_order add whether_timeout  tinyint(2) DEFAULT '1' COMMENT '是否超时 1否 2时';

alter table oshare_device_order add `overtime_pay` tinyint(2) DEFAULT '0' COMMENT '超时付款 1未付款 2已付款';
alter table oshare_device_order add `overtime` int(10) DEFAULT '0' COMMENT '超时时间';
alter table oshare_device_order add `early_amount` decimal(10,2) DEFAULT '0.00' COMMENT '提前进门金额';
alter table oshare_device_order add `pick_up_time` datetime DEFAULT NULL COMMENT '取货时间';
--0317
alter table oshare_parking_space add `numbering_flag`  varchar(50) DEFAULT NULL COMMENT '编号标识'  after publisher_id;

alter table oshare_car add `numbering_flag`  varchar(50) DEFAULT NULL COMMENT '编号标识'  after publisher_id;

--0318
alter table pshare_after_sale_order add `penalty_amount`  decimal(10,2) DEFAULT '0.00' COMMENT '惩罚金额';
alter table pshare_business_order add `penalty_amount`  decimal(10,2) DEFAULT '0.00' COMMENT '惩罚金额';

alter table pshare_business_order add `company_introduction`  varchar(255) DEFAULT NULL COMMENT '企业介绍';
alter table pshare_piece_order add `company_introduction`  varchar(222) DEFAULT NULL COMMENT '企业介绍';
alter table pshare_timing_order add `company_introduction`  varchar(255) DEFAULT NULL COMMENT '企业介绍';
alter table pshare_business_order_t add `company_introduction`  varchar(255) DEFAULT NULL COMMENT '企业介绍';
alter table pshare_piece_order_t add `company_introduction`  varchar(222) DEFAULT NULL COMMENT '企业介绍';
alter table pshare_timing_order_t add `company_introduction`  varchar(255) DEFAULT NULL COMMENT '企业介绍';

alter table oshare_device_order add `issued` tinyint(2) DEFAULT '1' COMMENT '下发标志 1未发 2已发';


alter table pshare_business_order_agency add `contract_pic` text COMMENT '合同图片'  after create_time;
alter table pshare_business_order_distribution add `contract_pic` text COMMENT '合同图片'  after create_time;
alter table pshare_business_order_transaction add `contract_pic` text COMMENT '合同图片'  after create_time;

--03/30
alter table oshare_car add `gear_type` tinyint(2) NOT NULL DEFAULT '0' COMMENT '档位类型 1自动挡 2手动档' after create_time;
alter table oshare_car add  `number_of_seats` int(11) NOT NULL COMMENT '座位数量' after create_time;
alter table oshare_car add  `insurance_pic` varchar(255) DEFAULT NULL COMMENT '保险图片' after create_time;
alter table oshare_car add   `car_pic` varchar(255) DEFAULT NULL COMMENT '汽车图片' after create_time;

alter table basic_auth_business add `company_introduction`  varchar(255) DEFAULT NULL COMMENT '企业介绍' after contact_tel;
alter table after_auth_business add `company_introduction`  varchar(255) DEFAULT NULL COMMENT '企业介绍' after contact_tel;
alter table business_auth_business add `company_introduction`  varchar(255) DEFAULT NULL COMMENT '企业介绍' after contact_tel;
alter table timing_auth_business add `company_introduction`  varchar(255) DEFAULT NULL COMMENT '企业介绍' after contact_tel;
alter table piece_auth_business add `company_introduction`  varchar(255) DEFAULT NULL COMMENT '企业介绍' after contact_tel;

alter table after_auth_orderer add `resume`  varchar(255) DEFAULT NULL COMMENT '简历' after contact_number;
alter table business_auth_orderer add `resume`  varchar(255) DEFAULT NULL COMMENT '简历' after contact_number;
alter table timing_auth_orderer add `resume`  varchar(255) DEFAULT NULL COMMENT '简历' after contact_number;
alter table piece_auth_orderer add `resume`  varchar(255) DEFAULT NULL COMMENT '简历' after contact_number;

alter table oshare_car add `car_id`  int(11) NOT NULL COMMENT '汽车内容ID' after product_id;
CREATE TABLE `parking_auth_owner_c` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `parking_auth_owner_id` int(11) NOT NULL COMMENT '认证id',
   `numbering` varchar(50) DEFAULT NULL COMMENT '设备编号',
  `parking_flag` varchar(50) DEFAULT NULL COMMENT '车位标识',
  `parking_pic` varchar(255) DEFAULT NULL COMMENT '车位主图',
  `parking_certificate` varchar(255) DEFAULT NULL COMMENT '车位凭证',
  `shared` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否共享 1：未共享 2：已共享',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='车位认证-所有者-汽车内容';

CREATE TABLE `filter_auth_owner_c` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `filter_auth_owner_id` int(11) NOT NULL COMMENT '认证id',
  `filter_flag` varchar(50) DEFAULT NULL COMMENT '净化器标识',
  `particle_value` varchar(50) DEFAULT NULL COMMENT '颗粒物CADR值',
  `formaldehyde_value` varchar(50) DEFAULT NULL COMMENT '甲醛CADR值',
  `uv_sterilization` tinyint(2) DEFAULT NULL COMMENT '紫外线杀菌 1是 2否',
  `carbon_monoxide_detection_alarm` tinyint(2) DEFAULT NULL COMMENT '一氧化碳检测报警 1是 2否',
  `filter_pic` varchar(255) DEFAULT NULL COMMENT '车位主图',
  `filter_certificate` varchar(255) DEFAULT NULL COMMENT '车位凭证',
  `shared` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否共享 1：未共享 2：已共享',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='净化器认证-所有者-净化器内容';

alter table oshare_device add `particle_value` varchar(50) DEFAULT NULL COMMENT '颗粒物CADR值' after introduction;
alter table oshare_device add `formaldehyde_value` varchar(50) DEFAULT NULL COMMENT '甲醛CADR值' after introduction;
alter table oshare_device add  `uv_sterilization` tinyint(2) DEFAULT NULL COMMENT '紫外线杀菌 1是 2否' after introduction;
alter table oshare_device add `carbon_monoxide_detection_alarm` tinyint(2) DEFAULT NULL COMMENT '一氧化碳检测报警 1是 2否' after introduction;
alter table oshare_device add  `filter_certificate` tinyint(2) DEFAULT NULL COMMENT '净化器凭证' after introduction;

alter table oshare_device add  `serial_number` int(11) DEFAULT NULL COMMENT '序号' after numbering_flag;
alter table oshare_car add  `serial_number` int(11) DEFAULT NULL COMMENT '序号' after numbering_flag;
alter table oshare_parking_space add  `serial_number` int(11) DEFAULT NULL COMMENT '序号' after numbering_flag;

alter table oshare_parking_space add  `main_picture` varchar(255) DEFAULT NULL COMMENT '主图' after pic;
alter table oshare_device add  `main_picture` varchar(255) DEFAULT NULL COMMENT '主图' after pic;

alter table oshare_device_order add  `pick_up_face_recognition` varchar(255) DEFAULT NULL COMMENT '取车人脸识别';
alter table oshare_device_order add  `return_face_recognition` varchar(255) DEFAULT NULL COMMENT '还车人脸识别';
alter table oshare_device_order add  `pick_up_photo` varchar(255) DEFAULT NULL COMMENT '取货照';
alter table oshare_device_order add  `return_photo` varchar(255) DEFAULT NULL COMMENT '还货照';

alter table oshare_device_order add  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见';
alter table oshare_parking_space_order add  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见';
alter table oshare_car_order add  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见';

--0402
alter table pshare_after_sale_order add `sign_in` text COMMENT '签到打卡';
alter table oshare_product_divided add `drop_site_id` int(11) DEFAULT NULL COMMENT '所属站点' after product_id;

alter table sys_setting add `pshare_platform_distribution` decimal(10,3) DEFAULT '0.000' COMMENT '人共享平台分润';
alter table sys_setting add `pshare_super_salesman_split` decimal(10,2) DEFAULT '0.00' COMMENT '人共享上级业务员分润';
CREATE TABLE `pshare_divided` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_id` int(20) DEFAULT NULL COMMENT '订单ID',
  `order_type` tinyint(2) DEFAULT NULL COMMENT '订单类型 1：计时分润 2：计件分润 3：售后分润 4：业务分润',
  `user_id` int(20) DEFAULT '0' COMMENT '分润用户',
  `divided_type` tinyint(2) DEFAULT NULL COMMENT '分润类型 1：平台分润 2：上级业务员分润 3：接单人分润',
  `divided_amount` decimal(10,2) DEFAULT NULL COMMENT '分润金额',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人共享分润表';

--0403
alter table pshare_piece_order add `reward_punishment` decimal(10,2) DEFAULT NULL COMMENT '其他奖罚';
alter table pshare_timing_order add `reward_punishment` decimal(10,2) DEFAULT NULL COMMENT '其他奖罚';
alter table pshare_piece_order add `picking_img` text COMMENT '领料信息';
alter table pshare_piece_order add `return_material_img` text COMMENT '还料信息';
alter table pshare_timing_order add `picking_img` text COMMENT '领料信息';
alter table pshare_timing_order add `return_material_img` text COMMENT '还料信息';

--0405
alter table after_auth_business add `del_status` tinyint(2) DEFAULT '0' COMMENT '是否删除 0否 2是';
alter table after_auth_orderer add `del_status` tinyint(2) DEFAULT '0' COMMENT '是否删除 0否 2是';
alter table business_auth_business add `del_status` tinyint(2) DEFAULT '0' COMMENT '是否删除 0否 2是';
alter table business_auth_orderer add `del_status` tinyint(2) DEFAULT '0' COMMENT '是否删除 0否 2是';
alter table car_auth_orderer add `del_status` tinyint(2) DEFAULT '0' COMMENT '是否删除 0否 2是';
alter table car_auth_owner add `del_status` tinyint(2) DEFAULT '0' COMMENT '是否删除 0否 2是';
alter table filter_auth_orderer add `del_status` tinyint(2) DEFAULT '0' COMMENT '是否删除 0否 2是';
alter table filter_auth_owner add `del_status` tinyint(2) DEFAULT '0' COMMENT '是否删除 0否 2是';
alter table parking_auth_orderer add `del_status` tinyint(2) DEFAULT '0' COMMENT '是否删除 0否 2是';
alter table parking_auth_owner add `del_status` tinyint(2) DEFAULT '0' COMMENT '是否删除 0否 2是';
alter table piece_auth_business add `del_status` tinyint(2) DEFAULT '0' COMMENT '是否删除 0否 2是';
alter table piece_auth_orderer add `del_status` tinyint(2) DEFAULT '0' COMMENT '是否删除 0否 2是';
alter table timing_auth_business add `del_status` tinyint(2) DEFAULT '0' COMMENT '是否删除 0否 2是';
alter table timing_auth_orderer add `del_status` tinyint(2) DEFAULT '0' COMMENT '是否删除 0否 2是';

--0414
alter table parking_auth_owner add `flag` tinyint(2) NOT NULL DEFAULT '1' COMMENT '标识状态[1审核中;2已通过;3已拒绝]';
alter table filter_auth_owner add `flag` tinyint(2) NOT NULL DEFAULT '1' COMMENT '标识状态[1审核中;2已通过;3已拒绝]';
alter table car_auth_owner add `flag` tinyint(2) NOT NULL DEFAULT '1' COMMENT '标识状态[1审核中;2已通过;3已拒绝]';

--0508
alter table application_management add `verification_method` varchar(55) DEFAULT NULL COMMENT '校验方法' after access_url_index;

CREATE TABLE `app_user_infrared` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `infrared_id` int(11) NOT NULL COMMENT '红外id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户红外关联表';



--0514
CREATE TABLE `oshare_intelligent_device_timing` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `device_id` int(11) DEFAULT NULL COMMENT '设备ID',
  `repeats` tinyint(2) DEFAULT '0' COMMENT '状态 0:一次 1:多次',
  `time` varchar(50) DEFAULT NULL COMMENT '时间 重复一次时间：2020-04-20 15:12;重复多次时间：15:20',
  `repeat_time` varchar(50) DEFAULT NULL COMMENT '重复时间 1 2 3 4 5 6 7',
  `action` tinyint(2) DEFAULT NULL COMMENT '动作 1:开 2:关',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='智能家居定时表';

CREATE TABLE `oshare_intelligent_device_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `device_id` int(11) DEFAULT NULL COMMENT '设备ID',
  `action` tinyint(2) DEFAULT NULL COMMENT '动作 1:开 2:关',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='智能家居记录表';

CREATE TABLE `oshare_intelligent_device_power` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `device_id` int(11) DEFAULT NULL COMMENT '设备ID',
  `total_duration` int(11) DEFAULT NULL COMMENT '总时长',
  `total_power` int(11) DEFAULT NULL COMMENT '总电量',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='智能家居电量表';

CREATE TABLE `oshare_intelligent_device` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `publisher_id` int(11) DEFAULT NULL COMMENT '发布人',
  `numbering` varchar(50) DEFAULT NULL COMMENT '设备编号',
  `numbering_flag` varchar(50) DEFAULT NULL COMMENT '编号标识',
  `serial_number` int(11) DEFAULT NULL COMMENT '序号',
  `type` tinyint(2) DEFAULT '1' COMMENT '设备类型 1:智能开关 2:智能插座',
  `shared` tinyint(2) DEFAULT '1' COMMENT '是否共享 1:否 2:是',
  `name` varchar(50) DEFAULT NULL COMMENT '设备名称',
  `product_id` int(20) DEFAULT NULL COMMENT '所属产品',
  `drop_site_id` int(20) DEFAULT NULL COMMENT '站点ID',
  `online_status` tinyint(2) DEFAULT '1' COMMENT '在线状态 1:新增 2:在线 3:离线',
  `main_picture` varchar(255) DEFAULT NULL COMMENT '主图',
  `lease_status` tinyint(2) DEFAULT NULL COMMENT '状态 1:发布审核 2:入库审核 3可租用 4不可租 5审核不通过 6下架',
  `hourly_price` decimal(10,2) DEFAULT NULL COMMENT '时租价格',
  `day_cap` decimal(10,2) DEFAULT NULL COMMENT '当日封顶',
  `start_time` varchar(30) DEFAULT NULL COMMENT '共享开始时间',
  `end_time` varchar(30) DEFAULT NULL COMMENT '共享结束时间',
  `qr_code` varchar(255) DEFAULT NULL COMMENT '设备二维码',
  `online_time` datetime DEFAULT NULL COMMENT '上线时间',
  `reason` varchar(255) DEFAULT NULL COMMENT '审批意见',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='智能家居设备';


CREATE TABLE `sh_auth_orderer` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真实姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
  `address` varchar(255) DEFAULT NULL COMMENT '详细地址',
  `idcard_front` varchar(255) DEFAULT NULL COMMENT '身份证正面',
  `idcard_reverse` varchar(255) DEFAULT NULL COMMENT '身份证反面',
  `face_recognition` varchar(255) DEFAULT NULL COMMENT '人脸识别',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `del_status` tinyint(2) DEFAULT '0' COMMENT '是否删除 0否 2是',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `is_auth_orderer_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='智慧家居租用认证';

CREATE TABLE `sh_auth_owner` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `real_name` varchar(25) DEFAULT NULL COMMENT '真实姓名',
  `idcard_no` varchar(55) DEFAULT NULL COMMENT '证件号码',
  `address` varchar(255) DEFAULT NULL COMMENT '详细地址',
  `idcard_front` varchar(255) DEFAULT NULL COMMENT '身份证正面',
  `idcard_reverse` varchar(255) DEFAULT NULL COMMENT '身份证反面',
  `face_recognition` varchar(255) DEFAULT NULL COMMENT '人脸识别',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态[1审核中;2已通过;3已拒绝]',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `del_status` tinyint(2) DEFAULT '0' COMMENT '是否删除 0否 2是',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `is_auth_owner_userid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='智慧家居发布认证';


CREATE TABLE `oshare_intelligent_device_order` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `order_number` varchar(64) DEFAULT NULL COMMENT '订单号',
  `user_id` int(20) DEFAULT NULL COMMENT '租户',
	`type` tinyint(2) DEFAULT '1' COMMENT '类型 1:智能开关;2:智能插座;3:。。。;4:。。。;5:。。。;6:。。。;',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态 1:待审核;2:待支付;3:待取货;4:待归还;5:归还审核;6:已完成;7:已取消；8：租赁不通过',
  `device_id` int(20) DEFAULT NULL COMMENT '设备',
  `drop_site_id` int(20) DEFAULT NULL COMMENT '所属站点',
  `deposit` decimal(10,2) DEFAULT NULL COMMENT '押金',
  `order_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单金额',
  `order_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '下单时间',
  `review_time` datetime DEFAULT NULL COMMENT '审核时间',
  `use_time` int(20) DEFAULT NULL COMMENT '使用时长（/分）',
  `payment_method` tinyint(2) DEFAULT NULL COMMENT '支付方式 1:余额;2:微信;3:支付宝',
  `payment_time` datetime DEFAULT NULL COMMENT '支付时间',
  `start_time` datetime DEFAULT NULL COMMENT '开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '结束时间',
  `rent_audit_time` datetime DEFAULT NULL COMMENT '租赁审核时间',
  `return_time` datetime DEFAULT NULL COMMENT '归还时间',
  `return_audit_time` datetime DEFAULT NULL COMMENT '归还审核时间',
  `lease_order_overtime` int(5) DEFAULT NULL COMMENT '未付款时自动取消时间',
  `service_fee` tinyint(2) DEFAULT '1' COMMENT '是否需要服务费 1否 2是',
  `whether_timeout` tinyint(2) DEFAULT '1' COMMENT '是否超时 1否 2时',
  `overtime_pay` tinyint(2) DEFAULT '0' COMMENT '超时付款 1未付款 2已付款',
  `overtime` int(10) DEFAULT '0' COMMENT '超时时间',
  `early_amount` decimal(10,2) DEFAULT '0.00' COMMENT '提前进门金额',
  `pick_up_time` datetime DEFAULT NULL COMMENT '取货时间',
  `confirm_pick_up` tinyint(2) DEFAULT '0' COMMENT '确认取货 1:未确认取货;2:已确认取货;',
  `confirm_return` tinyint(2) DEFAULT '0' COMMENT '确认归还 1:未确认归还;2:已确认归还;',
  `pick_up_code` varchar(64) DEFAULT NULL COMMENT '取货码',
  `return_code` varchar(64) DEFAULT NULL COMMENT '还货码',
  `issued` tinyint(2) DEFAULT '1' COMMENT '下发标志 1未发 2已发',
  `pick_up_face_recognition` varchar(255) DEFAULT NULL COMMENT '取货人脸识别',
  `return_face_recognition` varchar(255) DEFAULT NULL COMMENT '还货人脸识别',
  `pick_up_photo` text COMMENT '取货照',
  `return_photo` text COMMENT '还货照',
  `reason` varchar(255) DEFAULT NULL COMMENT '审核意见',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='智能设备订单';

alter table app_user_auth add `sh_auth_owner` tinyint(2) DEFAULT '0' COMMENT '智慧家居发布认证 0:未认证;1:审核中;2:已通过;3:已拒绝' after timing_auth_orderer;
alter table app_user_auth add `sh_auth_orderer` tinyint(2) DEFAULT '0' COMMENT '智慧家居租用认证 0:未认证;1:审核中;2:已通过;3:已拒绝' after sh_auth_owner;

说明：alter table + 表名 + add + 要添加的字段 + 字段类型 + comment "0盈利,1亏损" + after  + 要跟随的字段名 ;    （在这个字段后面添加一个字段）
