package tech.glinfo.enbao.modules.smartconfig;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.utils.*;

import java.io.IOException;
import java.util.Map;

@RestController
@RequestMapping("/smartconfig")
@Slf4j
public class SmartConfigController {

    private static final String appId = "wx983fb930ecd84b4d";

    private static final String appSecret = "2dce0e531552e9f80965f34309329942";



    private static final String REDIS_KEY = "app.smart.token.";
    private Long REDIS_KEY_IN = 21600L;

    @Autowired
    private RedisUtils redisUtils;

    @GetMapping("/getToken")
    public R getToken(@RequestParam("code") String code) {
        String info = getWechatInfo(code);
        if(info != null) {
            JSONObject json = JSONObject.parseObject(info);
            String openid = json.getString("openid");
            String md5 = MD5Util.getMD5Format(openid);
            redisUtils.set(REDIS_KEY+md5, 1, REDIS_KEY_IN);
            return R.ok().put("data", md5);
        } else {
            return R.error("获取token失败！");
        }
    }

    private String getWechatInfo(String code) {
        String url = "https://api.weixin.qq.com/sns/jscode2session?appid=" + appId + "&secret=" + appSecret + "&js_code=" + code + "&grant_type=authorization_code";
        //使用HttpClient发送请求
        CloseableHttpClient httpclient = HttpClients.createDefault();
        //发送Get请求
        HttpGet request = new HttpGet(url);
        request.addHeader("Content-Type", "application/json");
        //获得响应
        String result = null;// 转成string
        try {
            CloseableHttpResponse response = httpclient.execute(request);
            //拿到响应体
            HttpEntity httpEntity = response.getEntity();
            //使用工具转换
            result = EntityUtils.toString(httpEntity, "UTF-8");
        } catch (IOException e) {
            e.printStackTrace();
        }
        log.info("result:{}", result);
        return result;
    }


    @PostMapping("start")
    public R start(@RequestBody Map<String, Object> params) {
        String ssid = (String) params.get("ssid");
        String password = (String) params.get("password");
        String token = (String) params.get("token");

        if(StringUtils.isBlank(ssid, token)) {
            return R.error("缺少参数！");
        }
        if(redisUtils.hasKey(REDIS_KEY+token)) {
            AirKissEncoder airKissEncoder = new AirKissEncoder(ssid, password);
            return R.ok().put("data", airKissEncoder);
        } else {
            return R.error("token不存在或非法！");
        }

    }



}
