package tech.glinfo.enbao.modules.sh.form;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 房源场景关联设备
 * 
 * @author linzhenjie
 * @email linzhenjie@gltech.com
 * @date 2021-09-18 15:56:41
 */
@Data
@ApiModel(value = "房源场景关联设备")
public class ShDlinkDeviceForm implements Serializable {
	private static final long serialVersionUID = 1L;



	@ApiModelProperty(value = "场景")
//	@NotNull(message="场景不能为空")
	private Integer dlinkId;

	@ApiModelProperty(value = "关联设备")
	@NotNull(message="关联设备不能为空")
	private Integer deviceId;
	/**
	 * 指令
	 */
	private String cmd;

	/**
	 * 标识
	 */
	private Integer status2;

	@ApiModelProperty(value = "状态")
	@NotNull(message="状态不能为空")
	private Integer status;

	@ApiModelProperty(value = "设备编号")
	@NotBlank(message="设备编号不能为空")
	private String numbering;
}
