package tech.glinfo.enbao.modules.sh.form;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class ShDeviceForm {

    /**
     * 主键id
     */
    @ApiModelProperty(value = "ID，修改比传")
    private Integer id;

    @ApiModelProperty(value = "设备编号")
    @NotBlank(message="设备编号不能为空")
    private String numbering;

    @ApiModelProperty(value = "设备名称")
    @NotBlank(message="设备名称不能为空")
    private String name;

    @ApiModelProperty(value = "设备标识")
    @NotBlank(message="设备标识不能为空")
    private String numberingFlag;

    @ApiModelProperty(value = "设备标识")
    private String spareOne;

    @ApiModelProperty(value = "设备主图")
    @NotBlank(message="设备主图不能为空")
    private String mainPicture;

    @ApiModelProperty(value = "属性")
    @NotBlank(message="属性不能为空")
    private String attributes;

    @ApiModelProperty(value = "产品ID")
    @NotBlank(message="产品ID不能为空")
    private Integer productId;
}
