package tech.glinfo.enbao.modules.sh.form;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import tech.glinfo.enbao.common.utils.ByteUtils;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Protocol {

    private String head = "A57E";//头部 2
    private String sendId;//发送ID 10
    private String receiveId;//接收ID 10
    private String deviceType;//设备类型 1
    private String cmd;//命令/状态 1
    private Integer contentLength;//数据内容长度 1
    private String content;//数据内容 n
    private String checkCode;//校验码 2
    private String tail = "A50D";//尾部 2

    public static final String DEFAULT_DEVICEID = "0000000000000000000000000000";//协议报文长度

    //指令解析
    public Protocol(String msg) {
//        this.head = msg.substring(0, 4);
        this.sendId = msg.substring(4, 32);
        this.receiveId = msg.substring(32, 60);
        this.deviceType = msg.substring(60, 62);
        this.cmd = msg.substring(62, 64);
        this.contentLength = Integer.valueOf(msg.substring(64, 66), 16) * 2;
        this.content = msg.substring(66, msg.length()-8);
        this.checkCode = msg.substring(msg.length()-8, msg.length()-4);
//        this.tail = msg.substring(54 + this.contentLength);
    }

    public Protocol() {
    }

    /**
     * 获取发送的指令内容
     * @return
     */
    public String getSendContent() {
        StringBuilder content = new StringBuilder(head);
        StringBuilder body = new StringBuilder();
        body.append(DEFAULT_DEVICEID);
        body.append(this.receiveId);
        body.append(this.deviceType);
        body.append(this.cmd);
        if(this.content.length() > 510) {
            body.append("FF");
        } else {
            body.append(ByteUtils.int2Hex(this.content.length()/2));//长度
        }
        body.append(this.content);//内容
//        System.out.println(body);
        //校验码
        content.append(body).append(ByteUtils.makeCheckNum(body.toString()));
        content.append(this.tail);
        return content.toString();
    }

    public String getHead() {
        return head;
    }

    public void setHead(String head) {
        this.head = head;
    }

    public String getSendId() {
        return sendId;
    }

    public void setSendId(String sendId) {
        this.sendId = sendId;
    }

    public String getReceiveId() {
        return receiveId;
    }

    public void setReceiveId(String receiveId) {
        this.receiveId = receiveId;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getCmd() {
        return cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public Integer getContentLength() {
        return contentLength;
    }

    public void setContentLength(Integer contentLength) {
        this.contentLength = contentLength;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public String getTail() {
        return tail;
    }

    public void setTail(String tail) {
        this.tail = tail;
    }

    @Override
    public String toString() {
        return "ProtocolContent{" +
                "head='" + head + '\'' +
                ", sendId='" + sendId + '\'' +
                ", receiveId='" + receiveId + '\'' +
                ", deviceType='" + deviceType + '\'' +
                ", cmd='" + cmd + '\'' +
                ", contentLength=" + contentLength +
                ", content='" + content + '\'' +
                ", checkCode='" + checkCode + '\'' +
                ", tail='" + tail + '\'' +
                '}';
    }
}
