package tech.glinfo.enbao.modules.sh.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceRecordEntity;

import java.util.List;
import java.util.Map;

/**
 * 智能开关记录表
 * 
 * @author linzhenjie
 * @email linzhenjie@gltech.com
 * @date 2020-05-18 15:37:05
 */
@Mapper
public interface OtherShDeviceRecordDao extends BaseMapper<ShDeviceRecordEntity> {


    @Select("<script>" +
            "SELECT a.create_time createTime, a.action, remark, IFNULL(b.user_name, a.id) userName FROM sh_device_record a LEFT JOIN sh_lock_user b ON a.user_id = b.user_id AND b.lock_id = #{params.deviceId} WHERE a.device_id = #{params.deviceId}" +
            " 	<if test='params.time != null and params.time != \"\"' > "
            + "	        AND DATE_FORMAT(a.create_time, '%Y-%m') = #{params.time} "
            + "	    </if>"
            + "ORDER BY a.id DESC" +
            " </script>")
    List<Map<String, Object>> list(Page<Map<String, Object>> page, Map<String, Object> params);

    @Select("<script>" +
            "SELECT a.create_time createTime, remark, a.action FROM sh_device_record a WHERE a.device_id = ${deviceId}" +
            " <if test='start != null and start != \"\" and end != null and end != \"\"' > "
            + "	    and <![CDATA[ a.create_time >= #{start} and a.create_time <= #{end} ]]> "
            + "	</if>"
            + "ORDER BY a.id DESC" +
            " </script>")
    List<Map<String, Object>> list1(Map<String, Object> params);

    @Update("update sh_device_record set remark = '' WHERE device_id = ${deviceId}")
    void clearRemark(Integer deviceId);
}
