package tech.glinfo.enbao.modules.sh.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import tech.glinfo.enbao.modules.sh.entity.ShDevicePowerEntity;

/**
 * 智能开关电量表
 * 
 * @author linzhenjie
 * @email linzhenjie@gltech.com
 * @date 2020-05-18 15:37:05
 */
@Mapper
public interface OtherShDevicePowerDao extends BaseMapper<ShDevicePowerEntity> {

    @Select("<script>" +
            "SELECT * FROM sh_device_power WHERE DATE_FORMAT(create_time, '%Y-%m-%d') = #{time} AND device_id = ${deviceId}"
            + "</script>")
    ShDevicePowerEntity powerQuery(Integer deviceId, String time);

    @Select("<script>" +
            "SELECT * FROM sh_device_power WHERE " +
            "<![CDATA[ DATE_FORMAT(create_time, '%Y-%m-%d') >= #{startTime} AND DATE_FORMAT(create_time, '%Y-%m-%d') < #{entTime} ]]> " +
            "AND device_id = ${deviceId} ORDER BY id ASC LIMIT 1 "
            + "</script>")
    ShDevicePowerEntity startPower(Integer deviceId, String startTime, String entTime);

    @Select("<script>" +
            "SELECT * FROM sh_device_power WHERE " +
            "<![CDATA[ DATE_FORMAT(create_time, '%Y-%m-%d') <= #{entTime} AND DATE_FORMAT(create_time, '%Y-%m-%d') > #{startTime} ]]> " +
            "AND device_id = ${deviceId} ORDER BY id DESC LIMIT 1 "
            + "</script>")
    ShDevicePowerEntity entPower(Integer deviceId, String startTime, String entTime);

    @Select("<script>" +
            "SELECT * FROM sh_device_power WHERE DATE_FORMAT(create_time, '%Y-%m-%d') = #{time} AND device_id = ${deviceId}"
            + "</script>")
    ShDevicePowerEntity getPowerByTime(Integer deviceId, String time);
}
