package tech.glinfo.enbao.modules.sh.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.annotation.Login;
import tech.glinfo.enbao.common.utils.ImageUtils;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.StringUtils;
import tech.glinfo.enbao.modules.oss.cloud.OSSFactory;
import tech.glinfo.enbao.modules.service.BaiduApiService;
import tech.glinfo.enbao.modules.sh.entity.ShLockUserEntity;
import tech.glinfo.enbao.modules.sh.service.OtherShLockUserService;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/shLockUser")
@Api(value = "锁用户", description = "锁用户")
public class ShLockUserController {

    @Autowired
    private OtherShLockUserService otherShLockUserService;

    @Autowired
    private BaiduApiService baiduApiService;

    private static final String GROUPID = "glfacelock";//

    @Login
    @PostMapping("addFaceLock")
    @ApiOperation("添加人脸")
    @ApiLog("添加人脸")
    public R addFaceLock(@RequestBody Map<String, Object> params) {
        Integer id = (Integer) params.get("id");
        Integer deviceId = (Integer) params.get("deviceId");
        String img = (String) params.get("img");
        ShLockUserEntity lockUser = otherShLockUserService.getById(id);
        if (lockUser == null) {
            return R.error("用户不存在");
        }
        StringBuilder faceParam = new StringBuilder();
        //添加人脸
        JSONObject jsonObject = baiduApiService.addUser(ImageUtils.img2Base64(img), lockUser.getId().toString(), GROUPID + deviceId, lockUser.getUserName());
        if (jsonObject != null && jsonObject.has("error_code") && jsonObject.getInt("error_code") == 0) {
            JSONObject result = jsonObject.getJSONObject("result");
            faceParam.append(lockUser.getId().toString()).append(",").append(GROUPID).append(deviceId).append(",").append(result.getString("face_token"));
            //保存人脸参数
            lockUser.setFaceImg(img);
            lockUser.setFaceParam(faceParam.toString());
            otherShLockUserService.updateById(lockUser);
        } else {
            return R.error("添加失败");
        }
        return R.ok();
    }

    @Login
    @PostMapping("deleteFaceLock")
    @ApiOperation("删除人脸")
    @ApiLog("删除人脸")
    public R deleteFaceLock(@RequestBody Map<String, Object> params) {
        Integer id = (Integer) params.get("id");
        ShLockUserEntity lockUser = otherShLockUserService.getById(id);
        if (lockUser == null) {
            return R.error("用户不存在");
        }
       if (lockUser.getFaceParam() != null) {
           String[] faceParam = lockUser.getFaceParam().split(",");
           JSONObject jsonObject = baiduApiService.delUser(faceParam[0], faceParam[1], faceParam[2]);
           if (jsonObject != null && jsonObject.has("error_code") && jsonObject.getInt("error_code") == 0) {
               otherShLockUserService.deleteFaceLock(id);
               OSSFactory.build().delete(lockUser.getFaceImg());
           } else {
               return R.error("添加失败");
           }
       }
        return R.ok();
    }

    @Login
    @PostMapping("save")
    @ApiOperation("保存用户")
    @ApiLog("保存用户")
    public R save(@RequestBody Map<String, Object> params) {
        Integer lockId = (Integer) params.get("lockId");
        Integer userId = (Integer) params.get("userId");
        String userName = (String) params.get("userName");
        if (StringUtils.isBlank(lockId, userId, userName)) {
            return R.error("参数为空！");
        }
        ShLockUserEntity lockUserEntity = otherShLockUserService.getOne(new QueryWrapper<ShLockUserEntity>().eq("lock_id", lockId).eq("user_id", userId));
        if (lockUserEntity != null) {
            return R.error("用户ID不能重复！");
        }
        ShLockUserEntity entity = new ShLockUserEntity();
        entity.setLockId(lockId);
        entity.setUserId(userId);
        entity.setUserName(userName);
        boolean flag = otherShLockUserService.save(entity);
        return flag ? R.ok() : R.error("新增失败！");
    }

    @Login
    @PostMapping("update")
    @ApiOperation("修改用户")
    @ApiLog("修改用户")
    public R update(@RequestBody Map<String, Object> params) {
        Integer id = (Integer) params.get("id");
        Integer lockId = (Integer) params.get("lockId");
        Integer userId = (Integer) params.get("userId");
        String userName = (String) params.get("userName");
        if (StringUtils.isBlank(id, userId, userName)) {
            return R.error("参数为空！");
        }
        ShLockUserEntity lockUserEntity = otherShLockUserService.getOne(new QueryWrapper<ShLockUserEntity>().eq("lock_id", lockId).eq("user_id", userId));
        if (!lockUserEntity.getId().equals(id)) {
            return R.error("用户ID不能重复！");
        }
        ShLockUserEntity entity = new ShLockUserEntity();
        entity.setId(id);
        entity.setUserId(userId);
        entity.setUserName(userName);
        boolean flag = otherShLockUserService.updateById(entity);
        return flag ? R.ok() : R.error("修改失败！");
    }

    @Login
    @PostMapping("delete")
    @ApiOperation("删除用户")
    @ApiLog("删除用户")
    public R delete(@RequestBody Map<String, Object> params) {
        Integer id = (Integer) params.get("id");
        if (StringUtils.isBlank(id)) {
            return R.error("参数为空！");
        }
        boolean flag = otherShLockUserService.removeById(id);
        return flag ? R.ok() : R.error("删除失败！");
    }

    @Login
    @GetMapping("/list")
    @ApiOperation("锁用户列表")
    @ApiLog("锁用户列表")
    public R list(@RequestParam Map<String, Object> params) {
        Integer lockId = Integer.parseInt((String) params.get("lockId"));
        List<ShLockUserEntity> list = otherShLockUserService.list(new QueryWrapper<ShLockUserEntity>().eq("lock_id", lockId));
        return R.ok().put("list", list);
    }

}
