package tech.glinfo.enbao.modules.sh.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.annotation.Login;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.Query;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.StringUtils;
import tech.glinfo.enbao.modules.sh.entity.ShDevicePasswordEntity;
import tech.glinfo.enbao.modules.sh.service.ShDevicePasswordService;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

@RestController
@RequestMapping("/shDevicePassword")
@Api(value = "智能临时密码")
public class ShDevicePasswordController {


    @Autowired
    private ShDevicePasswordService shDevicePasswordService;

    @Login
    @GetMapping("list")
    @ApiOperation("临时密码列表")
    @ApiLog("临时密码列表")
    public R list(@RequestParam Map<String, Object> params) {
        Integer deviceId = Integer.parseInt((String) params.get("deviceId"));
        if (StringUtils.isBlank(deviceId)) {
            return R.error("缺少参数");
        }

        PageUtils page = new PageUtils(shDevicePasswordService.page(
                new Query<ShDevicePasswordEntity>().getPage(params),
                new QueryWrapper<ShDevicePasswordEntity>()
                .eq("device_id", deviceId)
                .eq("type", 2)
                .orderByDesc("id")
        ));

        return R.ok().put("page", page);
    }

    @Login
    @GetMapping("count")
    @ApiOperation("待下发密码数量")
    @ApiLog("待下发密码数量")
    public R count(@RequestParam Map<String, Object> params) {
        Integer deviceId = Integer.parseInt((String) params.get("deviceId"));
        if (StringUtils.isBlank(deviceId)) {
            return R.error("缺少参数");
        }
        Integer count = shDevicePasswordService.count(new QueryWrapper<ShDevicePasswordEntity>().eq("device_id", deviceId).eq("status", 1));


        return R.ok().put("count", count);
    }


    @Login
    @PostMapping("save")
    @ApiOperation("新增临时密码")
    @ApiLog("新增临时密码")
    public R save(@RequestBody Map<String, Object> params) throws ParseException {
        //表单校验
        Integer deviceId = (Integer) params.get("deviceId");
        String password = (String) params.get("password");
        Integer type = (Integer) params.get("type");
        String expiredTime = (String) params.get("expiredTime");
        if (StringUtils.isBlank(deviceId, password, type)) {
            return R.error("缺少参数！");
        }
        ShDevicePasswordEntity passwordEntity = new ShDevicePasswordEntity();
        passwordEntity.setDeviceId(deviceId);
        passwordEntity.setPassword(password);
        passwordEntity.setType(type);
        if (StringUtils.isNotBlank(expiredTime)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            Date date = sdf.parse(expiredTime);
            if (date.getTime() <= new Date().getTime()) {
                return R.error("失效时间不能小于当前时间！");
            }
            passwordEntity.setExpiredTime(sdf.parse(expiredTime));
        }
        return shDevicePasswordService.save(passwordEntity) ? R.ok() : R.error("保存失败！");
    }

}
