package tech.glinfo.enbao.modules.sh.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.annotation.Login;
import tech.glinfo.enbao.common.utils.MapUtils;
import tech.glinfo.enbao.common.validator.ValidatorUtils;
import tech.glinfo.enbao.modules.sh.entity.ShCarLockEntity;
import tech.glinfo.enbao.modules.sh.form.ShCarLockForm;
import tech.glinfo.enbao.modules.sh.service.ShCarLockService;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.R;



/**
 * 智能车门钥匙
 *
 * @author linyetong
 * @email linyetong@glinfo.com
 * @date 2022-05-24 10:27:45
 */
@RestController
@RequestMapping("/shCarLock")
public class ShCarLockController {
    @Autowired
    private ShCarLockService shCarLockService;

    /**
     * 列表
     */
    @Login
    @GetMapping("list/{id}")
    @ApiOperation("列表")
    @ApiLog("列表")
    public R list(@PathVariable("id") Integer id){
        List<ShCarLockEntity> list = shCarLockService.list(new QueryWrapper<ShCarLockEntity>().eq("device_id", id));

        return R.ok().put("list", list);
    }



    @Login
    @PostMapping("save")
    @ApiOperation("保存")
    @ApiLog("保存")
    public R save(@RequestBody ShCarLockForm form) throws InvocationTargetException, IllegalAccessException {
        ValidatorUtils.validateEntity(form);
        ShCarLockEntity shCarLock = new ShCarLockEntity();
        BeanUtils.copyProperties(shCarLock, form);
        boolean flag = shCarLockService.save(shCarLock);
        return flag ? R.ok() : R.error("保存失败");
    }

    /**
     * 删除
     */
    @Login
    @PostMapping("delete")
    @ApiOperation("删除")
    @ApiLog("删除")
    public R delete(@RequestBody Map<String, Object> params){
        Integer id = (Integer) params.get("id");
        Integer deviceId = (Integer) params.get("deviceId");
        MapUtils map = new MapUtils().put("device_id", deviceId);
        if(id != null) {
            map.put("id", id);
        }
        boolean flag = shCarLockService.removeByMap(map);
//        boolean flag = shCarLockService.removeById(id);
        return R.ok();
    }
}
