package tech.glinfo.enbao.modules.redis;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import tech.glinfo.enbao.modules.socketio.SocketIOService;

import java.util.Map;

@Slf4j
@Component
public class RedisReceiver {

    @Autowired
    private SocketIOService socketIOService;

    public void receiveMessage(String message, String channel) {
        log.info("redis subscribe receive message:channel:{},msg:{}", channel, message);
        try {
            Map<String, String> datas = (Map<String, String>) JSON.parse(message);
            socketIOService.pushMessageToDevice(datas.get("deviceId"), message);
//            logger.info("send message to websocket success : {}", message);
        } catch (Exception e) {
            log.error("parse message to websocket error : {}", e.getMessage());
        }
    }

}