package tech.glinfo.enbao.modules.infrared.form;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author lyt
 * @date 2021/7/27 10:44
 */
@Data
@ApiModel(value = "红外遥控")
public class InfraredControlForm {



    @ApiModelProperty(value = "ID，保存不用传，修改则传")
    private Integer id;

    @ApiModelProperty(value = "设备ID")
    private Integer deviceId;

    @ApiModelProperty(value = "设备类型")
    @NotBlank(message="设备类型不能为空")
    private String deviceType;
    
    @ApiModelProperty(value = "遥控类型")
//    @NotBlank(message="遥控类型不能为空")
    private String rtype;

    @ApiModelProperty(value = "品牌")
    @NotBlank(message="品牌不能为空")
    private String brand;

    @ApiModelProperty(value = "型号")
    @NotBlank(message="型号不能为空")
    private String model;

    @ApiModelProperty(value = "备注")
    private String remark;
}



