package tech.glinfo.enbao.modules.infrared.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import tech.glinfo.enbao.modules.infrared.entity.InfraredControlEntity;

import java.util.List;
import java.util.Map;

/**
 * 用户遥控器
 * 
 * @author linyetong
 * @email linyetong@glinfo.com
 * @date 2022-02-23 10:03:36
 */
@Mapper
public interface OtherInfraredControlDao extends BaseMapper<InfraredControlEntity> {


    @Select("<script>" +
            "SELECT a.id, a.device_id deviceId, a.user_id userId, a.device_type deviceType," +
            " a.rtype, a.brand, a.model, a.remark, c.name roomName FROM infrared_control a, sh_device b LEFT JOIN sh_family_room c ON b.room_id = c.id WHERE a.device_id = b.id AND" +
            "<choose>" +
            "  <when test='deviceId != null'>" +
            "     a.device_id = ${deviceId}" +
            "   </when>" +
            "    <otherwise>" +
            "      a.user_id = ${userId}" +
            "    </otherwise>" +
            " </choose>" +
            " </script>")
    List<Map<String, Object>> list(Integer deviceId, Integer userId);
}
