package tech.glinfo.enbao.modules.appuser.form;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 忘记密码表单
 *
 * @author linzhenjie@gltech.com
 */
@Data
@ApiModel(value = "忘记密码表单")
public class ForgetForm {

    @ApiModelProperty(value = "手机号")
    @NotBlank(message="手机号不能为空")
    private String phone;

    @ApiModelProperty(value = "新密码")
    @NotBlank(message="新密码不能为空")
    private String password;

    @ApiModelProperty(value = "验证码")
    @NotBlank(message="验证码不能为空")
    private String vcode;

}
