package tech.glinfo.enbao.common.utils;

public enum OpenSmartLockEnventEnum implements IEnventEnum{

    FACE("01", "密码开锁成功"),
    PWD("02", "卡片开锁成功"),
    CARD("03", "指纹开锁成功"),
    PALM("04", "手机远程开锁成功");

    OpenSmartLockEnventEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static String getName(String code) {
        for (OpenSmartLockEnventEnum c : OpenSmartLockEnventEnum.values()) {
            if (c.getCode().equals(code)) {
                return c.description;
            }
        }
        return null;
    }

    private String code;
    private String description;

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
