package tech.glinfo.enbao.common.utils;

import java.util.Arrays;
import java.util.Collections;

public class EncryptUtil {
    /**
     * 根据设备编号计算mqtt登录密码
     * @param sn 设备编号，14位 如002EB212230201
     * @return
     */
    public static String encrypt(String sn) {
        if(sn == null || sn.length() != 14) {
            return null;
        }
        String[] ns = sn.substring(5).split("");
        int len = ns.length;
        String[] ons = new String[len];
        System.arraycopy(ns, 0, ons, 0, ns.length);
        // 第一步把SN 码后 9位从大到小排序
        Arrays.sort(ns, Collections.reverseOrder());
//        System.out.println(Arrays.toString(ons));
//        System.out.println(Arrays.toString(ns));
        int sum = 0;
        int[] is = new int[len];
        // 第二步 排序后的与未排序的进行异或运算 并计算一个累加和
        for(int i=0; i < len; i++) {
            int a = Integer.valueOf(ns[i]);
            int b = Integer.valueOf(ons[i]);
            is[i] = a ^ b;
            sum += is[i];
        }
//        System.out.println(sum);
        char[] pwd = new char[len];
        // 第三步 异或后的再进行遍历一遍 并且加上该键值再加上累加和 再对26求余 再加上 97
        for(int i=0; i<len; i++) {
            pwd[i] = (char) ((i + sum + is[i]) % 26 + 97);
        }
//        System.out.println(String.valueOf(pwd));
        return String.valueOf(pwd);
    }
}
