package tech.glinfo.enbao.common.controller;

import com.aliyuncs.exceptions.ClientException;
import tech.glinfo.enbao.common.form.SendMsgForm;
import tech.glinfo.enbao.common.utils.*;
import tech.glinfo.enbao.common.validator.ValidatorUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.glinfo.enbao.common.utils.AliyunSmsAPIUtils;


/**
 * APP用户
 *
 * @author linzhenjie
 * @email linzhenjie@gltech.com
 * @date 2019-11-14 16:06:47
 */
@RestController
@RequestMapping("/common")
@Api(value = "APP公共接口", description = "APP公共接口")
public class CommonController extends AbstractController {

    @Autowired
    private RedisUtils redisUtils;

    @PostMapping("sendMsg")
    @ApiOperation("发送短信")
    public R sendMsg(@RequestBody SendMsgForm form) throws ClientException {
        //表单校验
        ValidatorUtils.validateEntity(form);

        String vcode = StringUtils.random(4, StringUtils.RandomType.INT);
        logger.info("验证码:{}", vcode);
        redisUtils.set(Constant.VCODE_KEY + form.getType() + "_" + form.getPhone(), vcode, 600);
        AliyunSmsAPIUtils.sendSms("SMS_182674601", form.getPhone(), "{\"code\":\"" + vcode + "\"}");
        return R.ok();
    }

}
