package tech.glinfo.enbao.modules.upgrade.utils;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.glinfo.enbao.common.utils.ByteUtils;
import tech.glinfo.enbao.common.utils.Constant;
import tech.glinfo.enbao.common.utils.StringUtils;
import tech.glinfo.enbao.modules.upgrade.entity.Protocol;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UpgradeUtils {

    private final static Logger logger = LoggerFactory.getLogger(UpgradeUtils.class);

    public static void main(String[] args) throws IOException {
        System.out.println("进入升级模式：");
        String deviceNo = "0000010000020002000000000001";
        String type = "01";
        sendF0(deviceNo, type);
        byte[] bytes = InputStream2ByteArray("D://Air_purifier_APP_V1.01_20200226.bin");
        int no = 1;
        int len = 0;
        int length = bytes.length - 12288;
        System.out.println("length:" + length);
        byte[] nbytes = new byte[length];
        System.arraycopy(bytes, 12288, nbytes, 0, length);
        System.out.println("文件信息：");
        sendF1(nbytes, deviceNo, type);
        System.out.println("文件数据：");
        while (len < length) {
            sendF2(nbytes, length, no, deviceNo, type);
            no++;
            len += 64;
        }
        System.out.println("退出升级模式：");
        sendF3(deviceNo, type);
    }

    public static String sendF0(String deviceNo, String type) {
        Protocol protocol = new Protocol();
        protocol.setCmd("F0");
        protocol.setContent("");
        protocol.setReceiveId(deviceNo);
        protocol.setDeviceType(type);
        String sendContent = JSON.toJSONString(protocol);
        logger.info("进入升级模式:{}", sendContent);
        return sendContent;
    }

    public static String sendF3(String deviceNo, String type) {
        Protocol protocol = new Protocol();
        protocol.setCmd("F3");
        protocol.setContent("");
        protocol.setReceiveId(deviceNo);
        protocol.setDeviceType(type);
        String sendContent = JSON.toJSONString(protocol);
        logger.info("退出升级模式:{}", sendContent);
        return sendContent;
    }

    public static String sendF2(byte[] bytes, int allLength, int no, String deviceNo, String type) {
//        System.out.println("length:" + length);
        int length = (no-1) * Constant.UPGRADE_DATA_LENGTH;
        logger.info("当前长度:{}", length);
        int leng = length + Constant.UPGRADE_DATA_LENGTH > allLength ? allLength - length : Constant.UPGRADE_DATA_LENGTH;
        byte[] b1 = new byte[leng];
        System.arraycopy(bytes, length, b1, 0, leng);
        String str = ByteUtils.bytes2HexString(b1);
//        System.out.println(str);
        String hexString = StringUtils.appendString(str, 128, true, "0");
//        System.out.println(hexString);
        Protocol protocol = new Protocol();
        protocol.setCmd("F2");
        protocol.setReceiveId(deviceNo);
        protocol.setDeviceType(type);
        protocol.setContent(StringUtils.appendString(String.valueOf(no), 4, true, "0") + hexString);
        String sendContent = JSON.toJSONString(protocol);
        logger.info("文件数据{}:{}", no, sendContent);
        return sendContent;
    }

    public static String sendF1(byte[] bytes, String deviceNo, String type) {
        int length = bytes.length;
//        System.out.println("length:" + length);
        String lenhex = ByteUtils.int2Hex(length);
        String fulllength = StringUtils.appendString(lenhex, 8, true, "0");
//        System.out.println(fulllength);
        String hexString = ByteUtils.bytes2HexString(bytes);
//        System.out.println(hexString);
        String num = ByteUtils.makeCheckNum(hexString);
//        System.out.println(num);
        Protocol protocol = new Protocol();
        protocol.setCmd("F1");
        protocol.setReceiveId(deviceNo);
        protocol.setDeviceType(type);
        protocol.setContent(fulllength + num);
        String sendContent = JSON.toJSONString(protocol);
        logger.info("文件信息:{}", sendContent);
        return sendContent;
    }

    public static byte[] InputStream2ByteArray(String filePath) throws IOException {

        InputStream in = new FileInputStream(filePath);
        byte[] data = toByteArray(in);
        in.close();

        return data;
    }

    private static byte[] toByteArray(InputStream in) throws IOException {

        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024 * 4];
        int n = 0;
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
        return out.toByteArray();
    }

}
