package tech.glinfo.enbao.modules.upgrade.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.glinfo.enbao.common.utils.ByteUtils;
import tech.glinfo.enbao.common.utils.Constant;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.RedisUtils;
import tech.glinfo.enbao.modules.mq.MqProducer;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceEntity;
import tech.glinfo.enbao.modules.sh.service.ShDeviceService;
import tech.glinfo.enbao.modules.upgrade.utils.UpgradeUtils;

import java.io.IOException;


/**
 * 设备固件升级
 *
 * @author linzhenjie
 * @email linzhenjie@gltech.com
 * @date 2020-01-13 11:35:31
 */
@RestController
@RequestMapping("upgrade")
public class UpgradeController {
    @Autowired
    private ShDeviceService shDeviceService;

    @Autowired
    private MqProducer mqProducer;

    @Autowired
    private RedisUtils redisUtils;

    /**
     * 升级设备固件
     */
    @RequestMapping("/device/{id}")
//    @RequiresPermissions("withdraw:info")
    public R info(@PathVariable("id") Integer id) {

        ShDeviceEntity deviceEntity = shDeviceService.getById(id);
        if (deviceEntity == null) {
            return R.error("设备不存在，请核实！");
        }

        if (deviceEntity.getOnlineStatus() != 2) {//设备不在线不能升级
            return R.error("设备不在线，不能升级！");
        }
        String status = redisUtils.get(Constant.UPGRADE_REDIS_KEY + deviceEntity.getNumbering() + ":status");
        if("1".equals(status)) {
            return R.error("设备正在升级中！");
        }

        //TODO 设备类型写死了，后面看怎么写活
        //把设备类型放入缓存
        redisUtils.set(Constant.UPGRADE_REDIS_KEY+deviceEntity.getNumbering()+":type", "01");
        //把该设备升级状态设置为升级中
        redisUtils.set(Constant.UPGRADE_REDIS_KEY+deviceEntity.getNumbering()+":status", "1");
        //进入升级模式
        mqProducer.sendUpgrade(UpgradeUtils.sendF0(deviceEntity.getNumbering(), "01"));

        return R.ok();
    }

    /**
     * 升级设备固件
     */
    @RequestMapping("/test")
//    @RequiresPermissions("withdraw:info")
    public R test() throws IOException {

        byte[] bytes = UpgradeUtils.InputStream2ByteArray("D://Air_purifier_APP_V1.01_20200226.bin");
        int length = bytes.length - 12288;
        System.out.println("length:" + length);
        byte[] nbytes = new byte[length];
        System.arraycopy(bytes, 12288, nbytes, 0, length);
        String hexString = ByteUtils.bytes2HexString(nbytes);
        System.out.println(hexString);
        redisUtils.set(Constant.UPGRADE_REDIS_KEY+"1234567890:content", hexString);

        String gb = redisUtils.get(Constant.UPGRADE_REDIS_KEY + "1234567890:content");
        System.out.println(gb);
        byte[] bytes1 = ByteUtils.hexStrToBinaryStr(gb);
        System.out.println("length1:" + bytes1.length);
        return R.ok();
    }

}
