package tech.glinfo.enbao.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.Query;
import tech.glinfo.enbao.modules.sys.dao.AppApiLogDao;
import tech.glinfo.enbao.modules.sys.entity.AppApiLogEntity;
import tech.glinfo.enbao.modules.sys.service.OtherAppApiLogService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service("otherAppApiLogService")
public class OtherAppApiLogServiceImpl extends ServiceImpl<AppApiLogDao, AppApiLogEntity> implements OtherAppApiLogService {

    @Override
    public PageUtils queryPage(Map<String, Object> params) {
        QueryWrapper<AppApiLogEntity> wrapper = new QueryWrapper<>();
        String key = (String) params.get("key");
        if(StringUtils.isNotEmpty(key)) {
            wrapper.eq("phone", key);
        }
        wrapper.orderByDesc("id");
        IPage<AppApiLogEntity> page = this.page(
                new Query<AppApiLogEntity>().getPage(params),
                wrapper
        );

        return new PageUtils(page);
    }

}