package tech.glinfo.enbao.modules.sys.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import tech.glinfo.enbao.modules.sys.entity.SysSettingEntity;
import tech.glinfo.enbao.modules.sys.service.SysSettingService;
import tech.glinfo.enbao.common.utils.R;



/**
 * 系统设置
 *
 * @author linzhenjie
 * @email linzhenjie@gltech.com
 * @date 2019-12-20 16:37:15
 */
@RestController
@RequestMapping("sys/syssetting")
public class SysSettingController {
    @Autowired
    private SysSettingService sysSettingService;


    /**
     * 信息
     */
    @RequestMapping("/info")
//    @RequiresPermissions("sys:syssetting:info")
    public R info(){
		SysSettingEntity sysSetting = sysSettingService.getOne(new QueryWrapper<SysSettingEntity>().last("LIMIT 1"));

        return R.ok().put("sysSetting", sysSetting);
    }


    /**
     * 修改
     */
    @RequestMapping("/update")
//    @RequiresPermissions("sys:syssetting:update")
    public R update(@RequestBody SysSettingEntity sysSetting){
		sysSettingService.updateById(sysSetting);

        return R.ok();
    }


}
