package tech.glinfo.enbao.modules.sys.controller;

import java.util.Arrays;
import java.util.Map;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import tech.glinfo.enbao.modules.sys.entity.FeedBackEntity;
import tech.glinfo.enbao.modules.sys.service.FeedBackService;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.R;



/**
 * 意见反馈
 *
 * @author linyetong
 * @email linyetong@glinfo.com
 * @date 2022-02-14 16:39:15
 */
@RestController
@RequestMapping("sys/feedback")
public class FeedBackController {
    @Autowired
    private FeedBackService feedBackService;

    /**
     * 列表
     */
    @RequestMapping("/list")
    public R list(@RequestParam Map<String, Object> params){
        PageUtils page = feedBackService.queryPage(params);

        return R.ok().put("page", page);
    }


    /**
     * 信息
     */
    @RequestMapping("/info/{id}")
    public R info(@PathVariable("id") Integer id){
		FeedBackEntity feedBack = feedBackService.getById(id);

        return R.ok().put("feedBack", feedBack);
    }

    /**
     * 保存
     */
    @RequestMapping("/save")
    public R save(@RequestBody FeedBackEntity feedBack){
		feedBackService.save(feedBack);

        return R.ok();
    }

    /**
     * 修改
     */
    @RequestMapping("/update")
    public R update(@RequestBody FeedBackEntity feedBack){
		feedBackService.updateById(feedBack);

        return R.ok();
    }

    /**
     * 删除
     */
    @RequestMapping("/delete")
    public R delete(@RequestBody Integer[] ids){
		feedBackService.removeByIds(Arrays.asList(ids));

        return R.ok();
    }

}
