package tech.glinfo.enbao.modules.sh.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.stereotype.Service;
import tech.glinfo.enbao.common.contants.Constants;
import tech.glinfo.enbao.common.utils.Constant;
import tech.glinfo.enbao.common.utils.MapUtils;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.StringUtils;
import tech.glinfo.enbao.modules.sh.dao.OtherShDeviceDao;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceEntity;
import tech.glinfo.enbao.modules.sh.service.OtherShDeviceService;

import javax.jms.Topic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author linyetong
 * @date 2019/12/13 12:29
 */

@Service("otherShDeviceService")
public class OtherShDeviceServiceImpl extends ServiceImpl<OtherShDeviceDao, ShDeviceEntity> implements OtherShDeviceService {

    @Autowired
    private Topic socketioTopic;

    @Autowired
    private JmsMessagingTemplate jmsTemplate;

    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public PageUtils queryPage(Map<String, Object> params) {
        int current = Integer.parseInt((String)params.get(Constant.PAGE));
        int size = Integer.parseInt((String)params.get(Constant.LIMIT));
        Page<Map<String, Object>> page = new Page<Map<String, Object>>(current, size);
        String time = (String) params.get("createTime");
        String start = null;
        String end = null;
        if (StringUtils.isNotBlank(time)) {
            start = time + " 00:00:00";
            end = time + " 59:59:59";
        }
        params.put("start", start);
        params.put("end", end);
        page.setRecords(this.baseMapper.list(page, params));
        return new PageUtils(page);
    }

    @Override
    public Map<String, Object> info(Integer id) {
        return this.baseMapper.info(id);
    }


    @Override
    public void timeout() {
        List<Map<String, Object>> list = this.baseMapper.timeout();
        List<Map<String, String>> mapList = new ArrayList<>();
        for (Map<String, Object> map : list) {
            ShDeviceEntity entity = new ShDeviceEntity();
            Integer id = (Integer) map.get("id");
            entity.setId(id);
            entity.setOnlineStatus(3);
            this.updateById(entity);
            Map<String, String> map1 = new HashMap<>();
            map1.put("deviceId", String.valueOf(id));
            map1.put("status", "3");
            mapList.add(map1);
            //发送到单个设备
//            jmsTemplate.convertAndSend(socketioTopic, JSON.toJSONString(new MapUtils().put("deviceId", String.valueOf(id)).put("status", "3")));
            redisTemplate.convertAndSend(Constants.REIDS_TOPIC, JSON.toJSONString(new MapUtils().put("deviceId", String.valueOf(id)).put("status", "3")));
        }
        //发送到主页所有设备
        if (mapList.size() > 0) {
            redisTemplate.convertAndSend(Constants.REIDS_TOPIC, JSON.toJSONString(new MapUtils().put("deviceId", "onlineStatus").put("list", mapList)));
        }
        //智能锁密码过期
        this.baseMapper.updateDevicePassword();
    }


}
