package tech.glinfo.enbao.modules.sh.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceEntity;

import java.util.List;
import java.util.Map;

/**
 * 站点
 * 
 * @author linzhenjie
 * @email linzhenjie@gltech.com
 * @date 2019-12-08 00:28:40
 */
@Mapper
public interface OtherShDeviceDao extends BaseMapper<ShDeviceEntity> {


    @Select("<script> " +
            "SELECT d.id, d.numbering, d.`name`, p.`name` productName, d.online_status onlineStatus, d.create_time createTime FROM sh_device d LEFT JOIN sh_product p ON d.product_id = p.id " +
            " <where>"
            + " locate('#',numbering) = 0"
            + " <if test='params.onlineStatus != null and params.onlineStatus != \"\"' > "
            + "	    and d.online_status = #{params.onlineStatus}"
            + "	</if>"
            + " <if test='params.numbering != null and params.numbering != \"\"' > "
            + "	    and d.numbering = #{params.numbering}"
            + "	</if>"
            + "</where> " +
            " ORDER BY d.id DESC" +
            "</script>")
    List<Map<String, Object>> list(Page<Map<String, Object>> page, Map<String, Object> params);

    @Select("<script>" +
            "SELECT a.*, b.name productName FROM sh_device a LEFT JOIN sh_product b ON  a.product_id = b.id WHERE a.id = ${id}" +
            "</script>")
    Map<String, Object> info(Integer id);


    @Select("select id from sh_device where online_status = 2 and online_time is not null and now() > date_add(online_time,interval 1 minute)")
    List<Map<String, Object>> timeout();

    @Select("<script>" +
            "update sh_device_password" +
            "        set status = 3" +
            "        where NOW() > expired_time" +
            "</script>")
    void updateDevicePassword();
}
