package tech.glinfo.enbao.modules.sh.controller;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.modules.sh.entity.ShProductEntity;
import tech.glinfo.enbao.modules.sh.service.OtherShProductService;

import java.util.Arrays;
import java.util.Map;


/**
 * 产品
 *
 * @author linzhenjie
 * @email linzhenjie@gltech.com
 * @date 2019-12-05 15:29:57
 */
@RestController
@RequestMapping("sh/product")
public class ShProductController {
    @Autowired
    private OtherShProductService otherShProductService;

    /**
     * 列表
     */
    @RequestMapping("/list")
    @RequiresPermissions("sh:product:list")
    public R list(@RequestParam Map<String, Object> params){
        PageUtils page = otherShProductService.queryPage(params);

        return R.ok().put("page", page);
    }

    /**
     * 列表
     */
    @RequestMapping("/listAll")
    public R listAll(){

        return R.ok().put("productOptions", otherShProductService.list());
    }


    /**
     * 信息
     */
    @RequestMapping("/info/{id}")
    @RequiresPermissions("sh:product:info")
    public R info(@PathVariable("id") Integer id){
		ShProductEntity shProduct = otherShProductService.getById(id);

        return R.ok().put("product", shProduct);
    }

    /**
     * 保存
     */
    @RequestMapping("/save")
    @RequiresPermissions("sh:product:save")
    public R save(@RequestBody ShProductEntity shProduct){
        otherShProductService.save(shProduct);

        return R.ok();
    }

    /**
     * 修改
     */
    @RequestMapping("/update")
    @RequiresPermissions("sh:product:update")
    public R update(@RequestBody ShProductEntity shProduct){
        otherShProductService.updateById(shProduct);

        return R.ok();
    }

    /**
     * 删除
     */
    @RequestMapping("/delete")
    @RequiresPermissions("sh:product:delete")
    public R delete(@RequestBody Integer[] ids){
        otherShProductService.removeByIds(Arrays.asList(ids));

        return R.ok();
    }

}
