package tech.glinfo.enbao.modules.mq;


import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import tech.glinfo.enbao.common.utils.ByteUtils;
import tech.glinfo.enbao.common.utils.RedisUtils;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceEntity;
import tech.glinfo.enbao.modules.sh.entity.ShInstructionParsingEntity;
import tech.glinfo.enbao.modules.sh.service.OtherShDeviceService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

//智能晾衣架
@Component("airerParse")
public class AirerParse implements IParse {

    private final static Logger logger = LoggerFactory.getLogger(AirerParse.class);

    @Autowired
    private OtherShDeviceService otherShDeviceService;

    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    private TimeParseUtils timeParseUtils;

    @Override
    public Map<String, String> run(Object o, Map<String, String> datas) {
        ShDeviceEntity device = (ShDeviceEntity) o;
        if("08".equals(datas.get("cmd"))) {//登录包

            redisUtils.set(datas.get("mac").toUpperCase(), datas.toString(), 180);//3分钟有效

            //校验设备时钟
            new Thread(() -> {
                logger.info("start checkDeviceTime");
                timeParseUtils.checkDeviceTime1(datas.get("receiveId"), datas.get("content"), "07");
            }).start();

            return datas;
        }


        Map<String, String> ws = new HashMap<>();

        if("07".equals(datas.get("cmd"))) {//实时数据上报
            String content = datas.get("content");
            //运行状态
            String eqh = content.substring(30, 32);
            String eq = String.valueOf(Integer.valueOf(eqh, 16));
            //灯状态
            String lighth = content.substring(32, 34);
            String light = String.valueOf(Integer.valueOf(lighth, 16));

            //紫外线状态
            String UVStateh = content.substring(34, 36);
            String UVState = String.valueOf(Integer.valueOf(UVStateh, 16));
            //风扇状态
            String fanStatush = content.substring(36, 38);
            String fanStatus = String.valueOf(Integer.valueOf(fanStatush, 16));
            //风扇状态
            String dryingHeatingStateh = content.substring(38, 40);
            String dryingHeatingState = String.valueOf(Integer.valueOf(dryingHeatingStateh, 16));

            logger.error("运行状态 : {}, 灯状态 : {}, 紫外线状态 : {}, 风扇状态 : {}, 风扇状态 : {}",
                    eq, light, UVState, fanStatus, dryingHeatingState);

            //查询解析指令集
            List<ShInstructionParsingEntity> cmds = otherShDeviceService.getDeviceInstructionList(device.getProductId(), datas.get("cmd"));
            if (cmds != null && cmds.size() > 0) {
                int length = 0;
                //解析设备报文内容
                Map<String, Object> map = new HashMap<>();
                for (ShInstructionParsingEntity cmd : cmds) {
                    String hex = content.substring(length, length + cmd.getLength());
                    String hex1;
                    if (cmd.getType() == 1 || cmd.getType() == 2) {
                        hex1 = String.valueOf(Integer.valueOf(hex, 16));

                    }else {
                        hex1 = ByteUtils.signHex2IntString(hex);
                    }
                    map.put(cmd.getName(), hex1);
                    ws.put(cmd.getName(), hex1);
                    length += cmd.getLength();
                }
                otherShDeviceService.updateDeviceData(JSON.toJSONString(map), device.getId());
            } else {
                ws = datas;
            }
        }


        if("18".equals(datas.get("cmd"))) {//开关响应
            String content = datas.get("content");
            //响应状态
            String eqh = content.substring(0, 2);
            String eq = String.valueOf(Integer.valueOf(eqh, 16));
            ws.put("action", eq);
        }
        return ws;
    }
}
