package tech.glinfo.enbao.modules.appuser.form;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 注册表单
 *
 * @author linzhenjie@gltech.com
 */
@Data
@ApiModel(value = "注册表单")
public class RegisterForm {

    @ApiModelProperty(value = "手机号码")
    @NotBlank(message="手机号码不能为空")
    private String phone;

    @ApiModelProperty(value = "密码")
    @NotBlank(message="密码不能为空")
    private String password;

    @ApiModelProperty(value = "昵称")
    @NotBlank(message="昵称不能为空")
    private String nickname;

    @ApiModelProperty(value = "验证码")
    @NotBlank(message="验证码不能为空")
    private String vcode;

}
