/**
 * Copyright (c) 2016-2019 人人开源 All rights reserved.
 *
 * https://www.renren.io
 *
 * 版权所有，侵权必究！
 */

package tech.glinfo.enbao.common.form;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 发送短信表单
 *
 * @author linzhenjie@gltech.com
 */
@Data
@ApiModel(value = "发送短信表单")
public class SendMsgForm {
    @ApiModelProperty(value = "手机号码")
    @NotBlank(message="手机号码不能为空")
    private String phone;

    @ApiModelProperty(value = "类型")
    @NotNull(message="类型不能为空")
    private Integer type;

}
