package tech.glinfo.enbao.common.utils;

/**
 * 常量
 *
 * @author Mark sunlightcs@gmail.com
 */
public class Constant {
	/** 超级管理员ID */
	public static final int SUPER_ADMIN = 1;
    /**
     * 当前页码
     */
    public static final String PAGE = "page";
    /**
     * 每页显示记录数
     */
    public static final String LIMIT = "limit";
    /**
     * 排序字段
     */
    public static final String ORDER_FIELD = "sidx";
    /**
     * 排序方式
     */
    public static final String ORDER = "order";
    /**
     *  升序
     */
    public static final String ASC = "asc";
    /**
     *  验证码缓存key前缀
     */
    public static final String VCODE_KEY = "vcode:key:";

    //消息缓存key
    public static final String MSG_REDIS_KEY = "device:msg:";
    public static Long MSG_REDIS_LENGTH = 50L;//保存50条记录

    //固件升级key
    public static final String UPGRADE_REDIS_KEY = "device:upgrade:";
    public static int UPGRADE_DATA_LENGTH = 64;//数据长度
    /**
	 * 菜单类型
	 */
    public enum VcodeType {
        /**
         * 注册
         */
    	REG(1),
        /**
         * 忘记密码
         */
        FORGET(2),
        /**
         * 快捷登录
         */
        LOGIN(3),
        /**
         * 其他
         */
        OTHERS(4);

        private int value;

        VcodeType(int value) {
            this.value = value;
        }

        public int getValue() {
            return value;
        }
    }
    /**
	 * 菜单类型
	 */
    public enum MenuType {
        /**
         * 目录
         */
    	CATALOG(0),
        /**
         * 菜单
         */
        MENU(1),
        /**
         * 按钮
         */
        BUTTON(2);

        private int value;

        MenuType(int value) {
            this.value = value;
        }

        public int getValue() {
            return value;
        }
    }

    /**
     * 定时任务状态
     * 
     * @author chenshun
     * @email sunlightcs@gmail.com
     * @date 2016年12月3日 上午12:07:22
     */
    public enum ScheduleStatus {
        /**
         * 正常
         */
    	NORMAL(0),
        /**
         * 暂停
         */
    	PAUSE(1);

        private int value;

        ScheduleStatus(int value) {
            this.value = value;
        }
        
        public int getValue() {
            return value;
        }
    }

    /**
     * 云服务商
     */
    public enum CloudService {
        /**
         * 七牛云
         */
        QINIU(1),
        /**
         * 阿里云
         */
        ALIYUN(2),
        /**
         * 腾讯云
         */
        QCLOUD(3);

        private int value;

        CloudService(int value) {
            this.value = value;
        }

        public int getValue() {
            return value;
        }
    }

    /**
     * 信息标题
     */
    public enum TitleType {
        /**
         * 售后订单审核成功
         */
        ATFERREVIEWSUCCESS("售后:审核成功"),
        /**
         * 售后订单审核失败
         */
        ATFERREVIEWFAILURE("售后:审核失败"),
        /**
         * 售后订单申请退单
         */
        ATFERCHARGBACK("售后:申请退单"),
        /**
         * 售后订单申请退单成功
         */
        ATFERCHARGBACKSUCCESS("售后:申请退单成功"),
        /**
         * 售后订单申请退单成功
         */
        ATFERCHARGBACKFAILURE("售后:申请退单失败"),

        /**
         * 售后订单接单成功
         */
        ATFERORDERSSUCCESS("售后:接单成功"),
        /**
         * 售后订单接单失败
         */
        ATFERORDERSFAILURE("售后:接单失败"),

        /**
         * 售后订单申诉失败
         */
        ATFERAPPEAL("售后:发起申诉"),

        /**
         * 售后订单申诉成功
         */
        ATFERAPPEALSUCCESS("售后:申诉成功"),

        /**
         * 售后订单申诉失败
         */
        ATFERAPPEALFAILURE("售后:申诉失败"),

        /**
         * 售后订单延迟申请
         */
        ATFERDELAY("售后:延迟申请"),
        /**
         * 售后订单延迟申请成功
         */
        ATFERDELAYSUCCESS("售后:延迟申请成功"),
        /**
         * 售后订单延迟申请失败
         */
        ATFERDELAYFAILURE("售后:延迟申请失败"),
        /**
         * 售后订单完成
         */
        ATFERCOMPLETE("售后:订单完成了"),


        /**
         * 业务订单审核成功
         */
        BUSINESSREVIEWSUCCESS("业务:审核成功"),
        /**
         * 业务订单审核失败
         */
        BUSINESSREVIEWFAILURE("业务:审核失败"),
        /**
         * 业务订单申请退单
         */
        BUSINESSCHARGBACK("业务:申请退单"),
        /**
         * 业务订单申请退单成功
         */
        BUSINESSCHARGBACKSUCCESS("业务:申请退单成功"),
        /**
         * 业务订单申请退单成功
         */
        BUSINESSCHARGBACKFAILURE("业务:申请退单失败"),

        /**
         * 业务订单接单成功
         */
        BUSINESSORDERSSUCCESS("业务:接单成功"),
        /**
         * 业务订单接单失败
         */
        BUSINESSORDERSFAILURE("业务:接单失败"),

        /**
         * 业务订单申诉失败
         */
        BUSINESSAPPEAL("业务:发起申诉"),

        /**
         * 业务订单申诉成功
         */
        BUSINESSAPPEALSUCCESS("业务:申诉成功"),

        /**
         * 业务订单申诉失败
         */
        BUSINESSAPPEALFAILURE("业务:申诉失败"),

        /**
         * 业务订单延迟申请
         */
        BUSINESSDELAY("业务:延迟申请"),
        /**
         * 业务订单延迟申请成功
         */
        BUSINESSDELAYSUCCESS("业务:延迟申请成功"),
        /**
         * 业务订单延迟申请失败
         */
        BUSINESSDELAYFAILURE("业务:延迟申请失败"),
        /**
         * 业务订单完成
         */
        BUSINESSCOMPLETE("业务:订单完成了"),


        /**
         * 计时订单审核成功
         */
        TIMINGREVIEWSUCCESS("计时:审核成功"),
        /**
         * 计时订单审核失败
         */
        TIMINGREVIEWFAILURE("计时:审核失败"),
        /**
         * 计时订单申请退单
         */
        TIMINGCHARGBACK("计时:申请退单"),
        /**
         * 计时订单申请退单成功
         */
        TIMINGCHARGBACKSUCCESS("计时:申请退单成功"),
        /**
         * 计时订单申请退单成功
         */
        TIMINGCHARGBACKFAILURE("计时:申请退单失败"),

        /**
         * 计时订单接单成功
         */
        TIMINGORDERSSUCCESS("计时:接单成功"),
        /**
         * 计时订单接单失败
         */
        TIMINGORDERSFAILURE("计时:接单失败"),

        /**
         * 计时订单申诉失败
         */
        TIMINGAPPEAL("计时:发起申诉"),

        /**
         * 计时订单申诉成功
         */
        TIMINGAPPEALSUCCESS("计时:申诉成功"),

        /**
         * 计时订单申诉失败
         */
        TIMINGAPPEALFAILURE("计时:申诉失败"),

        /**
         * 计时订单延迟申请
         */
        TIMINGDELAY("计时:延迟申请"),
        /**
         * 计时订单延迟申请成功
         */
        TIMINGDELAYSUCCESS("计时:延迟申请成功"),
        /**
         * 计时订单延迟申请失败
         */
        TIMINGDELAYFAILURE("计时:延迟申请失败"),
        /**
         * 计时订单完成
         */
        TIMINGCOMPLETE("计时:订单完成了"),



        /**
         * 计件订单审核成功
         */
        PIECEREVIEWSUCCESS("计件:审核成功"),
        /**
         * 计件订单审核失败
         */
        PIECEREVIEWFAILURE("计件:审核失败"),
        /**
         * 计件订单申请退单
         */
        PIECECHARGBACK("计件:申请退单"),
        /**
         * 计件订单申请退单成功
         */
        PIECECHARGBACKSUCCESS("计件:申请退单成功"),
        /**
         * 计件订单申请退单成功
         */
        PIECECHARGBACKFAILURE("计件:申请退单失败"),

        /**
         * 计件订单接单成功
         */
        PIECEORDERSSUCCESS("计件:接单成功"),
        /**
         * 计件订单接单失败
         */
        PIECEORDERSFAILURE("计件:接单失败"),

        /**
         * 计件订单申诉失败
         */
        PIECEAPPEAL("计件:发起申诉"),

        /**
         * 计件订单申诉成功
         */
        PIECEAPPEALSUCCESS("计件:申诉成功"),

        /**
         * 计件订单申诉失败
         */
        PIECEAPPEALFAILURE("计件:申诉失败"),

        /**
         * 计件订单延迟申请
         */
        PIECEDELAY("计件:延迟申请"),
        /**
         * 计件订单延迟申请成功
         */
        PIECEDELAYSUCCESS("计件:延迟申请成功"),
        /**
         * 计件订单延迟申请失败
         */
        PIECEDELAYFAILURE("计件:延迟申请失败"),
        /**
         * 计件订单完成
         */
        PIECECOMPLETE("计件:订单完成了"),


        /**
         * 认证成功
         */
        AUTHSUCCESS("认证成功"),

        /**
         * 认证失败
         */
        AUTHFAILURE("认证失败"),

        /**
         * 提现成功
         */
        WITHDRAWSUCCESS("认证成功"),

        /**
         * 提现失败
         */
        WITHDRAWFAILURE("认证失败");

        private String value;

        TitleType(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }

}
