package tech.glinfo.enbao.common.utils;

import com.baidu.aip.contentcensor.AipContentCensor;
import com.baidu.aip.face.AipFace;
import com.baidu.aip.ocr.AipOcr;
import com.baidu.aip.speech.AipSpeech;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * 百度api工具类
 */
@ConfigurationProperties(prefix = "baidu")
@Component
public class BaiDuApiUtils {
    private Logger logger = LoggerFactory.getLogger(getClass());
    private static String appId;
    private static String apiKey;
    private static String secretKey;

    public static String getAppId() {
        return appId;
    }

    public  void setAppId(String appId) {
        BaiDuApiUtils.appId = appId;
    }

    public static String getApiKey() {
        return apiKey;
    }

    public void setApiKey(String apiKey) {
        BaiDuApiUtils.apiKey = apiKey;
    }

    public static String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        BaiDuApiUtils.secretKey = secretKey;
    }

    /**
     * 获取API访问token
     * 该token有一定的有效期，需要自行管理，当失效时需重新获取.
     * @return assess_token 示例：
     * "24.460da4889caad24cccdb1fea17221975.2592000.1491995545.282335-1234567"
     */
    public static JSONObject getAuth() {
        // 获取token地址
        String authHost = "https://aip.baidubce.com/oauth/2.0/token?";
        String getAccessTokenUrl = authHost
                // 1. grant_type为固定参数
                + "grant_type=client_credentials"
                // 2. 官网获取的 API Key
                + "&client_id=" + apiKey
                // 3. 官网获取的 Secret Key
                + "&client_secret=" + secretKey;
        try {
            URL realUrl = new URL(getAccessTokenUrl);
            // 打开和URL之间的连接
            HttpURLConnection connection = (HttpURLConnection) realUrl.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            // 获取所有响应头字段
//            Map<String, List<String>> map = connection.getHeaderFields();
            // 遍历所有的响应头字段
            /*for (String key : map.keySet()) {
                System.err.println(key + "--->" + map.get(key));
            }*/
            // 定义 BufferedReader输入流来读取URL的响应
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder result = new StringBuilder();
            String line;
            while ((line = in.readLine()) != null) {
                result.append(line);
            }

//            System.err.println("result:" + result);
            return new JSONObject(result.toString());
        } catch (Exception e) {
            System.err.print("获取token失败！");
            e.printStackTrace(System.err);
        }
        return null;
    }

    //人脸识别
    public static AipFace getApiFace() {
        System.out.println("appId:" + appId);
        return ApiFaceUtils.instance;
    }

    private static class ApiFaceUtils {
        public final static AipFace instance = new AipFace(appId, apiKey, secretKey);
    }

    //内容审核
    public static AipContentCensor getAipContentCensor() {
        return AipContentCensorUtils.instance;
    }

    private static class AipContentCensorUtils {
        public final static AipContentCensor instance = new AipContentCensor(appId, apiKey, secretKey);
    }


}
