package tech.glinfo.enbao.modules.sh.form;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 房源场景
 * 
 * @author linzhenjie
 * @email linzhenjie@gltech.com
 * @date 2021-09-18 15:56:41
 */
@Data
@ApiModel(value = "房源场景")
public class ShDlinkForm implements Serializable {
	private static final long serialVersionUID = 1L;


	@ApiModelProperty(value = "房源场景ID")
	private Integer id;

	@ApiModelProperty(value = "房源ID")
//	@NotNull(message="房源ID不能为空")
	private Integer houseId;

	@ApiModelProperty(value = "标题")
	@NotBlank(message="标题不能为空")
	private String title;

	@ApiModelProperty(value = "生效时间段-开始")
	@NotBlank(message="生效时间段-开始不能为空")
	private String start;

	@ApiModelProperty(value = "生效时间段-结束")
	@NotBlank(message="生效时间段-结束不能为空")
	private String end;

	@ApiModelProperty(value = "发起设备")
	@NotNull(message="发起设备不能为空")
	private Integer deviceId;

	@ApiModelProperty(value = "状态")
	@NotNull(message="状态不能为空")
	private Integer status;

	@ApiModelProperty(value = "状态")
	private Integer statusO;

	@ApiModelProperty(value = "状态")
	private Integer statusT;

	@ApiModelProperty(value = "关联设备")
	private List<ShDlinkDeviceForm> devices;
}
