package tech.glinfo.enbao.modules.sh.controller;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.annotation.Login;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.StringUtils;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceRecordEntity;
import tech.glinfo.enbao.modules.sh.service.OtherShDeviceRecordService;

import java.util.Map;

@RestController
@RequestMapping("/shDeviceRecord")
@Api(value = "智能开关记录")
public class ShDeviceRecordController {


    @Autowired
    private OtherShDeviceRecordService otherShDeviceRecordService;

    @Login
    @GetMapping("list")
    @ApiOperation("智能开关记录列表")
    @ApiLog("智能开关记录列表")
    public R list(@RequestParam Map<String, Object> params) {
        if (StringUtils.isBlank(params.get("deviceId"))) {
            return R.error("缺少参数");
        }
        PageUtils page = otherShDeviceRecordService.queryPage(params);

        return R.ok().put("page", page);
    }


    @Login
    @PostMapping("save")
    @ApiOperation("新增记录")
    @ApiLog("新增记录")
    public R save(@RequestBody Map<String, Object> params) {
        //表单校验
        Integer deviceId = (Integer) params.get("deviceId");
        Integer action = (Integer) params.get("action");
        if (StringUtils.isBlank(deviceId, action)) {
            return R.error("缺少参数！");
        }
        ShDeviceRecordEntity recordEntity = new ShDeviceRecordEntity();
        recordEntity.setDeviceId(deviceId);
        recordEntity.setAction(action);
        return otherShDeviceRecordService.save(recordEntity) ? R.ok() : R.error("记录失败！");
    }

}
