/**
 * Copyright (c) 2016-2019 人人开源 All rights reserved.
 *
 * https://www.renren.io
 *
 * 版权所有，侵权必究！
 */

package tech.glinfo.enbao.modules.oss.controller;

import tech.glinfo.enbao.common.exception.RRException;
import tech.glinfo.enbao.common.utils.*;
import tech.glinfo.enbao.common.validator.ValidatorUtils;
import tech.glinfo.enbao.common.validator.group.AliyunGroup;
import tech.glinfo.enbao.common.validator.group.QcloudGroup;
import tech.glinfo.enbao.common.validator.group.QiniuGroup;
import tech.glinfo.enbao.modules.oss.cloud.CloudStorageConfig;
import tech.glinfo.enbao.modules.oss.cloud.OSSFactory;
import tech.glinfo.enbao.modules.sys.service.SysConfigService;
import tech.glinfo.enbao.modules.oss.entity.SysOssEntity;
import tech.glinfo.enbao.modules.oss.service.SysOssService;
import com.google.gson.Gson;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;

/**
 * 文件上传
 *
 * @author Mark sunlightcs@gmail.com
 */
@RestController
@RequestMapping("sys/oss")
public class SysOssController {
	@Autowired
	private SysOssService sysOssService;
    @Autowired
    private SysConfigService sysConfigService;

    private final static String KEY = ConfigConstant.CLOUD_STORAGE_CONFIG_KEY;
	
	/**
	 * 列表
	 */
	@GetMapping("/list")
	@RequiresPermissions("sys:oss:all")
	public R list(@RequestParam Map<String, Object> params){
		PageUtils page = sysOssService.queryPage(params);

		return R.ok().put("page", page);
	}


    /**
     * 云存储配置信息
     */
    @GetMapping("/config")
    @RequiresPermissions("sys:oss:all")
    public R config(){
        CloudStorageConfig config = sysConfigService.getConfigObject(KEY, CloudStorageConfig.class);

        return R.ok().put("config", config);
    }


	/**
	 * 备注
	 */
	@PostMapping("/remarks")
	@RequiresPermissions("sys:oss:all")
	public R remarks(@RequestParam("id") Long id, @RequestParam("remarks") String remarks){
		SysOssEntity ossEntity = new SysOssEntity();
		ossEntity.setId(id);
		ossEntity.setRemarks(remarks);
		sysOssService.updateById(ossEntity);

		return R.ok();
	}

	/**
	 * 保存云存储配置信息
	 */
	@PostMapping("/saveConfig")
	@RequiresPermissions("sys:oss:all")
	public R saveConfig(@RequestBody CloudStorageConfig config){
		//校验类型
		ValidatorUtils.validateEntity(config);

		if(config.getType() == Constant.CloudService.QINIU.getValue()){
			//校验七牛数据
			ValidatorUtils.validateEntity(config, QiniuGroup.class);
		}else if(config.getType() == Constant.CloudService.ALIYUN.getValue()){
			//校验阿里云数据
			ValidatorUtils.validateEntity(config, AliyunGroup.class);
		}else if(config.getType() == Constant.CloudService.QCLOUD.getValue()){
			//校验腾讯云数据
			ValidatorUtils.validateEntity(config, QcloudGroup.class);
		}

        sysConfigService.updateValueByKey(KEY, new Gson().toJson(config));

		return R.ok();
	}
	

	/**
	 * 上传文件
	 */
	@PostMapping("/upload")
	@RequiresPermissions("sys:oss:all")
	public R upload(@RequestParam("file") MultipartFile file, @RequestParam("id") String id) throws Exception {
		if (file.isEmpty()) {
			throw new RRException("上传文件不能为空");
		}
		String url = null;

		if(StringUtils.isNotBlank(id)) {
			SysOssEntity entity = sysOssService.getById(id);
			//上传文件
			url = OSSFactory.build(entity.getUrl()).upload(file.getBytes(), null);
		} else {
			//上传文件
			String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf("."));
			url = OSSFactory.build().uploadSuffix(file.getBytes(), suffix);

			//保存文件信息
			SysOssEntity ossEntity = new SysOssEntity();
			ossEntity.setUrl(url);
			ossEntity.setCreateDate(new Date());
			sysOssService.save(ossEntity);
		}

		return R.ok().put("url", url);
	}

	/**
	 * 上传文件
	 */
	@PostMapping("/edit")
	@RequiresPermissions("sys:oss:all")
	public R edit(@RequestParam("file") MultipartFile file, @RequestParam("fileName") String fileName) throws Exception {
		if (file.isEmpty()) {
			throw new RRException("上传文件不能为空");
		}
		if (fileName.isEmpty()) {
			throw new RRException("文件名不能为空");
		}

		//上传文件
		String url = OSSFactory.build(fileName).upload(file.getBytes(), fileName);

		return R.ok().put("url", url);
	}


	/**
	 * 删除
	 */
	@PostMapping("/delete")
	@RequiresPermissions("sys:oss:all")
	public R delete(@RequestBody Long[] ids){
		sysOssService.removeByIds(Arrays.asList(ids));



		return R.ok();
	}

}
