package tech.glinfo.enbao.common.utils;

public class NumberingUtil {
    static String[] NUMS = {"168889", "234567", "999999", "686548", "235647", "857462", "286341", "751787", "389789", "123456"};

    /**
     * 获取校验码
     * @param source
     * @return
     */
    public static String getCode(String source) {
        String end = source.substring(source.length() - 1);
        String target = source + NUMS[Integer.valueOf(end)];
//        System.out.println(target);
        return ByteUtils.makeCheckNum(ByteUtils.strToHex(target));
    }

    /**
     * 校验
     * @param source
     * @return
     */
    public static boolean checkCode(String source) {
        if(StringUtils.isEmpty(source) || source.length() != 18) {
            return false;
        }

        String code = getCode(source.substring(0, 14));
//        System.out.println(code);
        return code.equals(source.substring(14));
    }

    public static void main(String[] args) {
        System.out.println(getCode("013EB212800001"));
        System.out.println(getCode("009EB215200002"));
        System.out.println(getCode("011EB212800007"));
        System.out.println(getCode("011EB212800008"));
        System.out.println(getCode("011EB212800009"));
        System.out.println("00FEB213800002" + getCode("00FEB213800002"));
        System.out.println("00FEB213000003" + getCode("00FEB213000003"));
//        System.out.println(getCode("0000L202300001"));040F
//        System.out.println(checkCode("001EB2090000040412"));
    }

}
