package tech.glinfo.enbao.modules.sh.service.impl;

import com.baomidou.mybatisplus.extension.service.additional.query.impl.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.StringUtils;
import tech.glinfo.enbao.modules.appuser.entity.AppUserEntity;
import tech.glinfo.enbao.modules.sh.dao.OtherShFamilyRoomDao;
import tech.glinfo.enbao.modules.sh.dto.ShFamilyDto;
import tech.glinfo.enbao.modules.sh.entity.ShFamilyMemberEntity;
import tech.glinfo.enbao.modules.sh.entity.ShFamilyRoomEntity;
import tech.glinfo.enbao.modules.sh.service.OtherShFamilyRoomService;

import java.util.List;
import java.util.Map;

/**
 * @author lyt
 * @date 2022/1/5 10:49
 */
@Service("otherShFamilyRoomService")
public class OtherShFamilyRoomServiceImpl extends ServiceImpl<OtherShFamilyRoomDao, ShFamilyRoomEntity> implements OtherShFamilyRoomService {

    @Override
    public R addOrUpdate(Map<String, Object> params, AppUserEntity user) {
        String name = (String) params.get("name");
        Integer familyId = (Integer) params.get("familyId");
        if (StringUtils.isBlank(name, familyId)) {
            return R.error("缺少参数");
        }
        Integer id = (Integer) params.get("id");

        ShFamilyRoomEntity familyRoom = new ShFamilyRoomEntity();
        if (id != null) {
            familyRoom.setId(id);
        }
        familyRoom.setFamilyId(familyId);
        familyRoom.setName(name);
        familyRoom.setUserId(user.getId());
        this.saveOrUpdate(familyRoom);
        return R.ok();
    }


    @Override
    public R delete(Map<String, Object> params) {
        Integer id = (Integer) params.get("id");
        this.baseMapper.delete(id);
        return R.ok();
    }

    @Override
    public R list(Integer familyId) {

        return R.ok().put("data", this.baseMapper.list(familyId));
    }

    @Override
    public R info(Integer id) {

        return R.ok().put("room", this.getById(id));
    }

    @Override
    public R removeRelation(Integer deviceId) {
        this.baseMapper.removeRelation(deviceId);
        return R.ok();
    }


}
