package tech.glinfo.enbao.modules.sh.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.annotation.Login;
import tech.glinfo.enbao.common.utils.ByteUtils;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.RedisUtils;
import tech.glinfo.enbao.common.utils.StringUtils;
import tech.glinfo.enbao.common.validator.ValidatorUtils;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceEntity;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceTempEntity;
import tech.glinfo.enbao.modules.sh.form.ProtocolContent;
import tech.glinfo.enbao.modules.sh.form.ShDeviceTempForm;
import tech.glinfo.enbao.modules.sh.service.OtherShDeviceService;
import tech.glinfo.enbao.modules.sh.service.OtherShDeviceTempService;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;


@RestController
@RequestMapping("/shDeviceTemp")
@Api(value = "智能家居定时")
public class ShDeviceTempController {

    private final static Logger logger = LoggerFactory.getLogger(ShDeviceTempController.class);
    @Autowired
    private OtherShDeviceTempService otherShDeviceTempService;

    @Autowired
    private OtherShDeviceService otherShDeviceService;

    @Autowired
    private RedisUtils redisUtils;

    @Login
    @PostMapping("saveOrUpdate")
    @ApiOperation("新增、修改定时(智能插座、开关、窗帘)")
    @ApiLog("新增、修改定时")
    public R saveOrUpdate(@RequestBody ShDeviceTempForm form) throws InvocationTargetException, IllegalAccessException {
        //表单校验
        ValidatorUtils.validateEntity(form);
        ShDeviceTempEntity tempEntity = new ShDeviceTempEntity();
        BeanUtils.copyProperties(tempEntity, form);
        ShDeviceTempEntity tempEntity1 = otherShDeviceTempService.getOne(new QueryWrapper<ShDeviceTempEntity>().eq("device_id", form.getDeviceId()));
        if (tempEntity1 != null) {
            tempEntity.setId(tempEntity1.getId());
        }
        logger.info("低温" + tempEntity.getTempL());
        otherShDeviceTempService.saveOrUpdate(tempEntity);
        if (form.getStatus() == 1) {
            ShDeviceEntity entity = otherShDeviceService.getById(form.getDeviceId());

            String content = null;
            if (!StringUtils.isBlank(form.getTempH(), form.getMinuteH(), form.getSecondH(), form.getTempL(), form.getMinuteL(), form.getSecondL())) {
                String tempH = ByteUtils.signInt2HexString(form.getTempH().toString(), 2);
                String tempL = ByteUtils.signInt2HexString(form.getTempL().toString(), 2);

                StringBuilder minuteH = new StringBuilder(ByteUtils.int2Hex(form.getMinuteH()));
                while (minuteH.length() < 4) {
                    minuteH.insert(0, "0");
                }
                StringBuilder secondH = new StringBuilder(ByteUtils.int2Hex(form.getSecondH()));
                while (secondH.length() < 4) {
                    secondH.insert(0, "0");
                }
                StringBuilder minuteL = new StringBuilder(ByteUtils.int2Hex(form.getMinuteL()));
                while (minuteL.length() < 4) {
                    minuteL.insert(0, "0");
                }
                StringBuilder secondL = new StringBuilder(ByteUtils.int2Hex(form.getSecondL()));
                while (secondL.length() < 4) {
                    secondL.insert(0, "0");
                }
                content = "010103" + tempH + tempL + minuteH + secondH + minuteL + secondL;
            } else if (!StringUtils.isBlank(form.getTempH(), form.getMinuteH(), form.getSecondH())) {
                String tempH = ByteUtils.signInt2HexString(form.getTempH().toString(), 2);

                StringBuilder minuteH = new StringBuilder(ByteUtils.int2Hex(form.getMinuteH()));
                while (minuteH.length() < 4) {
                    minuteH.insert(0, "0");
                }
                StringBuilder secondH = new StringBuilder(ByteUtils.int2Hex(form.getSecondH()));
                while (secondH.length() < 4) {
                    secondH.insert(0, "0");
                }
                content = "010101" + tempH + "00" + minuteH + secondH + "00000000";
            } else if (!StringUtils.isBlank(form.getTempL(), form.getMinuteL(), form.getSecondL())) {
                String tempL = ByteUtils.signInt2HexString(form.getTempL().toString(), 2);

                StringBuilder minuteL = new StringBuilder(ByteUtils.int2Hex(form.getMinuteL()));
                while (minuteL.length() < 4) {
                    minuteL.insert(0, "0");
                }
                StringBuilder secondL = new StringBuilder(ByteUtils.int2Hex(form.getSecondL()));
                while (secondL.length() < 4) {
                    secondL.insert(0, "0");
                }
                content = "010102" + "00" + tempL + "00000000" + minuteL + secondL;
            }else {
                content = "00010000000000000000000000";
            }
            ProtocolContent protocol = new ProtocolContent();
            protocol.setReceiveId(entity.getNumbering());
            protocol.setDeviceType("03");
            protocol.setCmd("1C");
            protocol.setContent(content);
            String json = JSON.toJSONString(protocol);
            redisUtils.set("device:sendtemp:" + entity.getNumbering(), json);
        }
        return R.ok().put("id", tempEntity.getId());
    }


    @Login
    @PostMapping("saveOrUpdate1")
    @ApiOperation("新增、修改定时(智能插座、开关、窗帘)")
    @ApiLog("新增、修改定时")
    public R saveOrUpdate1(@RequestBody ShDeviceTempForm form) throws InvocationTargetException, IllegalAccessException {
        //表单校验
        ValidatorUtils.validateEntity(form);
        ShDeviceTempEntity tempEntity = new ShDeviceTempEntity();
        BeanUtils.copyProperties(tempEntity, form);
        otherShDeviceTempService.saveOrUpdate(tempEntity);
        ShDeviceEntity entity = otherShDeviceService.getById(form.getDeviceId());

        String content = null;
        String content1 = null;
        if (form.getFlag() == 1) {
            if (form.getStatus() == 1) {
                if (!StringUtils.isBlank(form.getTempH(), form.getMinuteH(), form.getSecondH(), form.getTempL(), form.getMinuteL(), form.getSecondL())) {
                    String tempH = ByteUtils.signInt2HexString(form.getTempH().toString(), 2);
                    String tempL = ByteUtils.signInt2HexString(form.getTempL().toString(), 2);

                    StringBuilder minuteH = new StringBuilder(ByteUtils.int2Hex(form.getMinuteH()));
                    while (minuteH.length() < 4) {
                        minuteH.insert(0, "0");
                    }
                    StringBuilder secondH = new StringBuilder(ByteUtils.int2Hex(form.getSecondH()));
                    while (secondH.length() < 4) {
                        secondH.insert(0, "0");
                    }
                    StringBuilder minuteL = new StringBuilder(ByteUtils.int2Hex(form.getMinuteL()));
                    while (minuteL.length() < 4) {
                        minuteL.insert(0, "0");
                    }
                    StringBuilder secondL = new StringBuilder(ByteUtils.int2Hex(form.getSecondL()));
                    while (secondL.length() < 4) {
                        secondL.insert(0, "0");
                    }
                    content = "010103" + tempH + tempL + minuteH + secondH + minuteL + secondL;
                } else if (!StringUtils.isBlank(form.getTempH(), form.getMinuteH(), form.getSecondH())) {
                    String tempH = ByteUtils.signInt2HexString(form.getTempH().toString(), 2);

                    StringBuilder minuteH = new StringBuilder(ByteUtils.int2Hex(form.getMinuteH()));
                    while (minuteH.length() < 4) {
                        minuteH.insert(0, "0");
                    }
                    StringBuilder secondH = new StringBuilder(ByteUtils.int2Hex(form.getSecondH()));
                    while (secondH.length() < 4) {
                        secondH.insert(0, "0");
                    }
                    content = "010101" + tempH + "00" + minuteH + secondH + "00000000";
                } else if (!StringUtils.isBlank(form.getTempL(), form.getMinuteL(), form.getSecondL())) {
                    String tempL = ByteUtils.signInt2HexString(form.getTempL().toString(), 2);

                    StringBuilder minuteL = new StringBuilder(ByteUtils.int2Hex(form.getMinuteL()));
                    while (minuteL.length() < 4) {
                        minuteL.insert(0, "0");
                    }
                    StringBuilder secondL = new StringBuilder(ByteUtils.int2Hex(form.getSecondL()));
                    while (secondL.length() < 4) {
                        secondL.insert(0, "0");
                    }
                    content = "010102" + "00" + tempL + "00000000" + minuteL + secondL;
                }else {
                    content = "00010000000000000000000000";
                }

                ProtocolContent protocol = new ProtocolContent();
                protocol.setReceiveId(entity.getNumbering());
                protocol.setDeviceType("02");
                protocol.setCmd("1C");
                protocol.setContent(content);
                String json = JSON.toJSONString(protocol);
                redisUtils.set("device:sendtemp1:" + entity.getNumbering(), json);

            }

        }else {
            if (form.getStatusT() == 1) {
                if (!StringUtils.isBlank(form.getTempHT(), form.getMinuteHT(), form.getSecondHT(), form.getTempLT(), form.getMinuteLT(), form.getSecondLT())) {
                    String tempH = ByteUtils.signInt2HexString(form.getTempHT().toString(), 2);
                    String tempL = ByteUtils.signInt2HexString(form.getTempLT().toString(), 2);

                    StringBuilder minuteH = new StringBuilder(ByteUtils.int2Hex(form.getMinuteHT()));
                    while (minuteH.length() < 4) {
                        minuteH.insert(0, "0");
                    }
                    StringBuilder secondH = new StringBuilder(ByteUtils.int2Hex(form.getSecondHT()));
                    while (secondH.length() < 4) {
                        secondH.insert(0, "0");
                    }
                    StringBuilder minuteL = new StringBuilder(ByteUtils.int2Hex(form.getMinuteLT()));
                    while (minuteL.length() < 4) {
                        minuteL.insert(0, "0");
                    }
                    StringBuilder secondL = new StringBuilder(ByteUtils.int2Hex(form.getSecondLT()));
                    while (secondL.length() < 4) {
                        secondL.insert(0, "0");
                    }
                    content1 = "010203" + tempH + tempL + minuteH + secondH + minuteL + secondL;
                } else if (!StringUtils.isBlank(form.getTempHT(), form.getMinuteHT(), form.getSecondHT())) {
                    String tempH = ByteUtils.signInt2HexString(form.getTempHT().toString(), 2);

                    StringBuilder minuteH = new StringBuilder(ByteUtils.int2Hex(form.getMinuteHT()));
                    while (minuteH.length() < 4) {
                        minuteH.insert(0, "0");
                    }
                    StringBuilder secondH = new StringBuilder(ByteUtils.int2Hex(form.getSecondHT()));
                    while (secondH.length() < 4) {
                        secondH.insert(0, "0");
                    }
                    content1 = "010201" + tempH + "00" + minuteH + secondH + "00000000";
                } else if (!StringUtils.isBlank(form.getTempLT(), form.getMinuteLT(), form.getSecondLT())) {
                    String tempL = ByteUtils.signInt2HexString(form.getTempLT().toString(), 2);

                    StringBuilder minuteL = new StringBuilder(ByteUtils.int2Hex(form.getMinuteLT()));
                    while (minuteL.length() < 4) {
                        minuteL.insert(0, "0");
                    }
                    StringBuilder secondL = new StringBuilder(ByteUtils.int2Hex(form.getSecondLT()));
                    while (secondL.length() < 4) {
                        secondL.insert(0, "0");
                    }
                    content1 = "010202" + "00" + tempL + "00000000" + minuteL + secondL;
                }else {
                    content1 = "00020000000000000000000000";
                }

                ProtocolContent protocol1 = new ProtocolContent();
                protocol1.setReceiveId(entity.getNumbering());
                protocol1.setDeviceType("02");
                protocol1.setCmd("1C");
                protocol1.setContent(content1);
                String json1 = JSON.toJSONString(protocol1);
                redisUtils.set("device:sendtemp2:" + entity.getNumbering(), json1);
            }
        }

        return R.ok().put("id", tempEntity.getId());
    }


    @Login
    @GetMapping("info/{id}")
    @ApiOperation("定时详情(智能插座、开关、窗帘)")
    @ApiLog("定时详情")
    public R info(@PathVariable("id") Integer id) {
        return R.ok().put("temp", otherShDeviceTempService.getOne(new QueryWrapper<ShDeviceTempEntity>().eq("device_id", id)));
    }


    @Login
    @PostMapping("updateStatus")
    @ApiOperation("修改状态")
    @ApiLog("修改状态")
    public R updateStatus(@RequestBody Map<String, Object> params) {
        Integer id = (Integer) params.get("id");
        Integer status = (Integer) params.get("status");
        
        if (StringUtils.isBlank(id, status)) {
            return R.error("缺少参数！");
        }
        ShDeviceTempEntity tempEntity = new ShDeviceTempEntity();
        tempEntity.setId(id);
        tempEntity.setStatus(status);
        otherShDeviceTempService.updateById(tempEntity);
        ShDeviceTempEntity tempEntity1 = otherShDeviceTempService.getById(id);
        ShDeviceEntity entity = otherShDeviceService.getById(tempEntity1.getDeviceId());
        String content;

        if (status == 1) {
            content = content(tempEntity1);
        }else {
            content = "00010000000000000000000000";
        }
        ProtocolContent protocol = new ProtocolContent();
        protocol.setReceiveId(entity.getNumbering());
        protocol.setDeviceType("03");
        protocol.setCmd("1C");
        protocol.setContent(content);
        String json = JSON.toJSONString(protocol);
        redisUtils.set("device:sendtemp:" + entity.getNumbering(), json);

        return R.ok();
    }


    @Login
    @PostMapping("updateStatus1")
    @ApiOperation("修改状态")
    @ApiLog("修改状态")
    public R updateStatus1(@RequestBody Map<String, Object> params) {
        Integer id = (Integer) params.get("id");
        Integer status = (Integer) params.get("status");
        Integer statusT = (Integer) params.get("statusT");
        if (StringUtils.isBlank(id)) {
            return R.error("缺少参数！");
        }
        if (status == null && statusT == null) {
            return R.error("缺少参数！");
        }
        ShDeviceTempEntity tempEntity = new ShDeviceTempEntity();
        tempEntity.setId(id);
        if(status != null) {
            tempEntity.setStatus(status);
        }
        if(statusT != null) {
            tempEntity.setStatusT(statusT);
        }
        otherShDeviceTempService.updateById(tempEntity);
        ShDeviceTempEntity tempEntity1 = otherShDeviceTempService.getById(id);
        ShDeviceEntity entity = otherShDeviceService.getById(tempEntity1.getDeviceId());
        String content = null;

        if (status != null && status == 1) {
            if (!StringUtils.isBlank(tempEntity1.getTempH(), tempEntity1.getMinuteH(), tempEntity1.getSecondH(), tempEntity1.getTempL(), tempEntity1.getMinuteL(), tempEntity1.getSecondL())) {
                String tempH = ByteUtils.signInt2HexString(tempEntity1.getTempH().toString(), 2);
                String tempL = ByteUtils.signInt2HexString(tempEntity1.getTempL().toString(), 2);

                StringBuilder minuteH = new StringBuilder(ByteUtils.int2Hex(tempEntity1.getMinuteH()));
                while (minuteH.length() < 4) {
                    minuteH.insert(0, "0");
                }
                StringBuilder secondH = new StringBuilder(ByteUtils.int2Hex(tempEntity1.getSecondH()));
                while (secondH.length() < 4) {
                    secondH.insert(0, "0");
                }
                StringBuilder minuteL = new StringBuilder(ByteUtils.int2Hex(tempEntity1.getMinuteL()));
                while (minuteL.length() < 4) {
                    minuteL.insert(0, "0");
                }
                StringBuilder secondL = new StringBuilder(ByteUtils.int2Hex(tempEntity1.getSecondL()));
                while (secondL.length() < 4) {
                    secondL.insert(0, "0");
                }
                content = "010103" + tempH + tempL + minuteH + secondH + minuteL + secondL;
            } else if (!StringUtils.isBlank(tempEntity1.getTempH(), tempEntity1.getMinuteH(), tempEntity1.getSecondH())) {
                String tempH = ByteUtils.signInt2HexString(tempEntity1.getTempH().toString(), 2);

                StringBuilder minuteH = new StringBuilder(ByteUtils.int2Hex(tempEntity1.getMinuteH()));
                while (minuteH.length() < 4) {
                    minuteH.insert(0, "0");
                }
                StringBuilder secondH = new StringBuilder(ByteUtils.int2Hex(tempEntity1.getSecondH()));
                while (secondH.length() < 4) {
                    secondH.insert(0, "0");
                }
                content = "010101" + tempH + "00" + minuteH + secondH + "00000000";
            } else if (!StringUtils.isBlank(tempEntity1.getTempL(), tempEntity1.getMinuteL(), tempEntity1.getSecondL())) {
                String tempL = ByteUtils.signInt2HexString(tempEntity1.getTempL().toString(), 2);

                StringBuilder minuteL = new StringBuilder(ByteUtils.int2Hex(tempEntity1.getMinuteL()));
                while (minuteL.length() < 4) {
                    minuteL.insert(0, "0");
                }
                StringBuilder secondL = new StringBuilder(ByteUtils.int2Hex(tempEntity1.getSecondL()));
                while (secondL.length() < 4) {
                    secondL.insert(0, "0");
                }
                content = "010102" + "00" + tempL + "00000000" + minuteL + secondL;
            }else {
                content = "00010000000000000000000000";
            }

           
        }else if (status != null && status == 2){
            content = "00010000000000000000000000";
        }else if (statusT != null && statusT == 1){
            if (!StringUtils.isBlank(tempEntity1.getTempHT(), tempEntity1.getMinuteHT(), tempEntity1.getSecondHT())) {
                String tempH = ByteUtils.signInt2HexString(tempEntity1.getTempHT().toString(), 2);

                StringBuilder minuteH = new StringBuilder(ByteUtils.int2Hex(tempEntity1.getMinuteHT()));
                while (minuteH.length() < 4) {
                    minuteH.insert(0, "0");
                }
                StringBuilder secondH = new StringBuilder(ByteUtils.int2Hex(tempEntity1.getSecondHT()));
                while (secondH.length() < 4) {
                    secondH.insert(0, "0");
                }
                content = "010201" + tempH + "00" + minuteH + secondH + "00000000";
            } else if (!StringUtils.isBlank(tempEntity1.getTempLT(), tempEntity1.getMinuteLT(), tempEntity1.getSecondLT())) {
                String tempL = ByteUtils.signInt2HexString(tempEntity1.getTempLT().toString(), 2);

                StringBuilder minuteL = new StringBuilder(ByteUtils.int2Hex(tempEntity1.getMinuteLT()));
                while (minuteL.length() < 4) {
                    minuteL.insert(0, "0");
                }
                StringBuilder secondL = new StringBuilder(ByteUtils.int2Hex(tempEntity1.getSecondLT()));
                while (secondL.length() < 4) {
                    secondL.insert(0, "0");
                }
                content = "010202" + "00" + tempL + "00000000" + minuteL + secondL;
            }else {
                content = "00020000000000000000000000";
            }
        }else if (statusT != null && statusT == 2){
            content = "00020000000000000000000000";
        }
        ProtocolContent protocol = new ProtocolContent();
        protocol.setReceiveId(entity.getNumbering());
        protocol.setDeviceType("02");
        protocol.setCmd("1C");
        protocol.setContent(content);
        String json = JSON.toJSONString(protocol);
        if (status != null) {
            redisUtils.set("device:sendtemp1:" + entity.getNumbering(), json);
        }

        if (statusT != null) {
            redisUtils.set("device:sendtemp2:" + entity.getNumbering(), json);
        }

        return R.ok();
    }
    
    
    private String content(ShDeviceTempEntity tempEntity) {
        String content;
        if (!StringUtils.isBlank(tempEntity.getTempH(), tempEntity.getMinuteH(), tempEntity.getSecondH(), tempEntity.getTempL(), tempEntity.getMinuteL(), tempEntity.getSecondL())) {
            String tempH = ByteUtils.signInt2HexString(tempEntity.getTempH().toString(), 2);
            String tempL = ByteUtils.signInt2HexString(tempEntity.getTempL().toString(), 2);

            StringBuilder minuteH = new StringBuilder(ByteUtils.int2Hex(tempEntity.getMinuteH()));
            while (minuteH.length() < 4) {
                minuteH.insert(0, "0");
            }
            StringBuilder secondH = new StringBuilder(ByteUtils.int2Hex(tempEntity.getSecondH()));
            while (secondH.length() < 4) {
                secondH.insert(0, "0");
            }
            StringBuilder minuteL = new StringBuilder(ByteUtils.int2Hex(tempEntity.getMinuteL()));
            while (minuteL.length() < 4) {
                minuteL.insert(0, "0");
            }
            StringBuilder secondL = new StringBuilder(ByteUtils.int2Hex(tempEntity.getSecondL()));
            while (secondL.length() < 4) {
                secondL.insert(0, "0");
            }
            content = "010103" + tempH + tempL + minuteH + secondH + minuteL + secondL;
        } else if (!StringUtils.isBlank(tempEntity.getTempH(), tempEntity.getMinuteH(), tempEntity.getSecondH())) {
            String tempH = ByteUtils.signInt2HexString(tempEntity.getTempH().toString(), 2);

            StringBuilder minuteH = new StringBuilder(ByteUtils.int2Hex(tempEntity.getMinuteH()));
            while (minuteH.length() < 4) {
                minuteH.insert(0, "0");
            }
            StringBuilder secondH = new StringBuilder(ByteUtils.int2Hex(tempEntity.getSecondH()));
            while (secondH.length() < 4) {
                secondH.insert(0, "0");
            }
            content = "010101" + tempH + "00" + minuteH + secondH + "00000000";
        } else if (!StringUtils.isBlank(tempEntity.getTempL(), tempEntity.getMinuteL(), tempEntity.getSecondL())) {
            String tempL = ByteUtils.signInt2HexString(tempEntity.getTempL().toString(), 2);

            StringBuilder minuteL = new StringBuilder(ByteUtils.int2Hex(tempEntity.getMinuteL()));
            while (minuteL.length() < 4) {
                minuteL.insert(0, "0");
            }
            StringBuilder secondL = new StringBuilder(ByteUtils.int2Hex(tempEntity.getSecondL()));
            while (secondL.length() < 4) {
                secondL.insert(0, "0");
            }
            content = "010102" + "00" + tempL + "00000000" + minuteL + secondL;
        }else {
            content = "00010000000000000000000000";
        }

        return content;
    }

}