package tech.glinfo.enbao.modules.sys.controller;

import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.modules.sys.entity.AppApiLogEntity;
import tech.glinfo.enbao.modules.sys.service.OtherAppApiLogService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.Map;

/**
 * API日志
 *
 * @author linzhenjie
 * @email linzhenjie@gltech.com
 * @date 2019-11-18 21:22:34
 */
@RestController
@RequestMapping("sys/appapilog")
public class AppApiLogController {
    @Autowired
    private OtherAppApiLogService appApiLogService;

    /**
     * 列表
     */
    @RequestMapping("/list")
    @RequiresPermissions("sys:appapilog:list")
    public R list(@RequestParam Map<String, Object> params){
        PageUtils page = appApiLogService.queryPage(params);

        return R.ok().put("page", page);
    }


    /**
     * 信息
     */
    @RequestMapping("/info/{id}")
    @RequiresPermissions("sys:appapilog:info")
    public R info(@PathVariable("id") Long id){
		AppApiLogEntity appApiLog = appApiLogService.getById(id);

        return R.ok().put("appApiLog", appApiLog);
    }

    /**
     * 保存
     */
    @RequestMapping("/save")
    @RequiresPermissions("sys:appapilog:save")
    public R save(@RequestBody AppApiLogEntity appApiLog){
		appApiLogService.save(appApiLog);

        return R.ok();
    }

    /**
     * 修改
     */
    @RequestMapping("/update")
    @RequiresPermissions("sys:appapilog:update")
    public R update(@RequestBody AppApiLogEntity appApiLog){
		appApiLogService.updateById(appApiLog);

        return R.ok();
    }

    /**
     * 删除
     */
    @RequestMapping("/delete")
    @RequiresPermissions("sys:appapilog:delete")
    public R delete(@RequestBody Long[] ids){
		appApiLogService.removeByIds(Arrays.asList(ids));

        return R.ok();
    }

}
