package tech.glinfo.enbao.modules.appuser.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.Query;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.StringUtils;
import tech.glinfo.enbao.modules.appuser.entity.AppUserEntity;
import tech.glinfo.enbao.modules.appuser.service.AppUserService;

import java.util.Map;

/**
 * @author lyt
 * @date 2021/12/24 19:00
 */
@RestController
@RequestMapping("appuser")
public class AppUserController {

    @Autowired
    private AppUserService appUserService;


    /**
     * 列表
     */
    @RequestMapping("/list")
    @RequiresPermissions("appuser:list")
    public R list(@RequestParam Map<String, Object> params){
        String phone = (String) params.get("phone");
        IPage<AppUserEntity> page = appUserService.page(
                new Query<AppUserEntity>().getPage(params),
                new QueryWrapper<AppUserEntity>()
                        .like(StringUtils.isNotBlank(phone),"phone", phone)
                        .orderByDesc("id")
        );



        PageUtils page1 = new PageUtils(page);

        return R.ok().put("page", page1);
    }


    /**
     * 信息
     */
    @RequestMapping("/info/{id}")
    @RequiresPermissions("appuser:info")
    public R info(@PathVariable("id") Integer id){
        AppUserEntity appUser = appUserService.getById(id);

        return R.ok().put("appUser", appUser);
    }


    /**
     * 修改
     */
    @RequestMapping("/update")
    @RequiresPermissions("appuser:update")
    public R update(@RequestBody AppUserEntity appUser){
        appUserService.updateById(appUser);

        return R.ok();
    }

}
