package tech.glinfo.enbao.common.utils;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 阿里云短信bean
 */
@ConfigurationProperties(prefix = "aliyunsms")
@Component
public class AliyunSmsAPIUtils {
    private static Logger logger = LoggerFactory.getLogger(AliyunSmsAPIUtils.class);

    private static String accessKeyId;
    private static String secret;
    private static String sendSwitch;//开关 true/false

    public static IAcsClient getIAcsClient() {
        return ApiUtils.instance;
    }

    private static class ApiUtils {
        // 设置鉴权参数，初始化客户端
        private static DefaultProfile profile = DefaultProfile.getProfile(
                "cn-hangzhou",// 地域ID
                AliyunSmsAPIUtils.accessKeyId,// 您的AccessKey ID
                AliyunSmsAPIUtils.secret);// 您的AccessKey Secret
        public final static IAcsClient instance = new DefaultAcsClient(profile);
    }

    private static void log_print(String functionName, Object result) {
        Gson gson = new Gson();
        logger.info("-------------------------------" + functionName + "-------------------------------");
        logger.info(gson.toJson(result));
    }

    /**
     * 发送短信
     */
    public static String sendSms(String templateCode, String phone, String params) throws ClientException {
        if(!"true".equals(AliyunSmsAPIUtils.sendSwitch)) {
            logger.info("短信开关：{}" , AliyunSmsAPIUtils.sendSwitch);
            return null;
        }
        CommonRequest request = new CommonRequest();
        request.setSysDomain("dysmsapi.aliyuncs.com");
        request.setSysVersion("2017-05-25");
        request.setSysAction("SendSms");
        // 接收短信的手机号码
        request.putQueryParameter("PhoneNumbers", phone);
        // 短信签名名称。请在控制台签名管理页面签名名称一列查看（必须是已添加、并通过审核的短信签名）。
        request.putQueryParameter("SignName", "桀狮科技");
        // 短信模板ID
        request.putQueryParameter("TemplateCode", templateCode);
        // 短信模板变量对应的实际值，JSON格式。
        request.putQueryParameter("TemplateParam", params);//"{\"code\":\"8888\"}");
        IAcsClient client = AliyunSmsAPIUtils.getIAcsClient();
        CommonResponse commonResponse = client.getCommonResponse(request);
        String data = commonResponse.getData();
        String sData = data.replaceAll("'\'", "");
        log_print("sendSms", sData);
        Gson gson = new Gson();
        Map map = gson.fromJson(sData, Map.class);
        Object bizId = map.get("BizId");
        return "";
    }

    public String getAccessKeyId() {
        return accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        AliyunSmsAPIUtils.accessKeyId = accessKeyId;
    }

    public String getSecret() {
        return secret;
    }

    public void setSecret(String secret) {
        AliyunSmsAPIUtils.secret = secret;
    }

    public String getSendSwitch() {
        return sendSwitch;
    }

    public void setSendSwitch(String sendSwitch) {
        AliyunSmsAPIUtils.sendSwitch = sendSwitch;
    }
}
