package tech.glinfo.enbao.modules.sys.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.modules.sys.entity.HelpCenterContentEntity;
import tech.glinfo.enbao.modules.sys.entity.HelpCenterEntity;
import tech.glinfo.enbao.modules.sys.form.HelpCenterContentForm;
import tech.glinfo.enbao.modules.sys.form.HelpCenterForm;
import tech.glinfo.enbao.modules.sys.service.HelpCenterContentService;
import tech.glinfo.enbao.modules.sys.service.HelpCenterService;

import java.util.*;


/**
 * 帮助中心
 *
 * @author linyetong
 * @email linyetong@glinfo.com
 * @date 2022-02-14 16:39:15
 */
@RestController
@RequestMapping("sys/helpcenter")
public class HelpCenterController {
    @Autowired
    private HelpCenterService helpCenterService;

    @Autowired
    private HelpCenterContentService helpCenterContentService;

    /**
     * 列表
     */
    @RequestMapping("/list")
    public R list(@RequestParam Map<String, Object> params) {
        PageUtils page = helpCenterService.queryPage(params);

        return R.ok().put("page", page);
    }


    /**
     * 信息
     */
    @RequestMapping("/info/{id}")
    public R info(@PathVariable("id") Integer id) {
        HelpCenterEntity helpCenter = helpCenterService.getById(id);
        List<HelpCenterContentEntity> list = helpCenterContentService.list(new QueryWrapper<HelpCenterContentEntity>().eq("help_id", helpCenter.getId()));
        List<Map<String, Object>> mapList = new ArrayList<>();
        for (HelpCenterContentEntity content : list) {
            Map<String, Object> map = new HashMap<>();
            map.put("type", content.getType());
            if (content.getType().equals("img")) {
                map.put("content", content.getContent().split(","));
            } else {
                map.put("content", content.getContent());
            }
            mapList.add(map);
        }

        return R.ok().put("helpCenter", helpCenter).put("mapList", mapList);
    }

    /**
     * 保存
     */
    @RequestMapping("/save")
    public R save(@RequestBody HelpCenterForm form) {
        HelpCenterEntity helpCenter = new HelpCenterEntity();
        helpCenter.setTitle(form.getTitle());
        helpCenterService.save(helpCenter);
        for (HelpCenterContentForm content : form.getContents()) {
            HelpCenterContentEntity contentEntity = new HelpCenterContentEntity();
            contentEntity.setHelpId(helpCenter.getId());
            contentEntity.setType(content.getType());
            contentEntity.setContent(content.getContent());
            helpCenterContentService.save(contentEntity);
        }
        return R.ok();
    }

    /**
     * 修改
     */
    @RequestMapping("/update")
    public R update(@RequestBody HelpCenterForm form) {
        HelpCenterEntity helpCenter = new HelpCenterEntity();
        helpCenter.setId(form.getId());
        helpCenter.setTitle(form.getTitle());
        helpCenterService.updateById(helpCenter);
        helpCenterContentService.remove(new QueryWrapper<HelpCenterContentEntity>().eq("help_id", form.getId()));
        for (HelpCenterContentForm content : form.getContents()) {
            HelpCenterContentEntity contentEntity = new HelpCenterContentEntity();
            contentEntity.setHelpId(helpCenter.getId());
            contentEntity.setType(content.getType());
            contentEntity.setContent(content.getContent());
            helpCenterContentService.save(contentEntity);
        }
        return R.ok();
    }

    /**
     * 删除
     */
    @RequestMapping("/delete")
    public R delete(@RequestBody Integer[] ids) {
        helpCenterService.removeByIds(Arrays.asList(ids));

        return R.ok();
    }

}
