package tech.glinfo.enbao.modules.sh.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.StringUtils;
import tech.glinfo.enbao.modules.appuser.entity.AppUserEntity;
import tech.glinfo.enbao.modules.sh.dao.OtherShFamilyDao;
import tech.glinfo.enbao.modules.sh.dto.ShFamilyDto;
import tech.glinfo.enbao.modules.sh.entity.ShFamilyEntity;
import tech.glinfo.enbao.modules.sh.entity.ShFamilyMemberEntity;
import tech.glinfo.enbao.modules.sh.service.OtherShFamilyService;
import tech.glinfo.enbao.modules.sh.service.ShFamilyMemberService;

import java.util.List;
import java.util.Map;

/**
 * @author lyt
 * @date 2022/1/5 10:49
 */
@Service("otherShFamilyService")
public class OtherShFamilyServiceImpl extends ServiceImpl<OtherShFamilyDao, ShFamilyEntity> implements OtherShFamilyService {

    @Autowired
    private ShFamilyMemberService shFamilyMemberService;

    @Override
    public R add(Map<String, Object> params, AppUserEntity user) {
        String name = (String) params.get("name");
        if (StringUtils.isBlank(name)) {
            return R.error("缺少参数");
        }

        //新增家庭
        ShFamilyEntity family = new ShFamilyEntity();
        family.setName(name);
        family.setUserId(user.getId());
        this.save(family);

        //新增家庭成员
        ShFamilyMemberEntity member = new ShFamilyMemberEntity();
        member.setFamilyId(family.getId());
        member.setUserId(user.getId());
        member.setIsAdmin(1);//管理员
        shFamilyMemberService.save(member);
        return R.ok();
    }

    @Override
    public R update(Map<String, Object> params) {
        Integer id = (Integer) params.get("id");
        String name = (String) params.get("name");
        if (StringUtils.isBlank(id, name)) {
            return R.error("缺少参数");
        }
        ShFamilyEntity family = new ShFamilyEntity();
        family.setId(id);
        family.setName(name);
        this.updateById(family);
        return R.ok();
    }

    @Override
    public R delete(Map<String, Object> params, AppUserEntity user) {
        int count = this.count(new QueryWrapper<ShFamilyEntity>().eq("user_id", user.getId()));
        if (count == 1) {
            return R.error("不能全部删除家庭");
        }
        Integer id = (Integer) params.get("id");
        this.baseMapper.delete(id);
        return R.ok();
    }

    @Override
    public R list(AppUserEntity user) {
        List<Map<String, Object>> list = this.baseMapper.list(user.getId());

        return R.ok().put("data", list);
    }

    @Override
    public R info(Integer id) {
        ShFamilyDto family = this.baseMapper.familyInfo(id);

        return R.ok().put("family", family);
    }


}
