package tech.glinfo.enbao.common.utils;

public enum OpenEnventEnum implements IEnventEnum{

    FACE("01", "人脸开锁事件"),
    PWD("02", "密码开锁事件"),
    CARD("03", "卡片开锁事件"),
    PALM("04", "掌静脉开锁事件"),
    FINGER("05", "指纹开锁事件"),
    YC("06", "手机远程开锁");

    OpenEnventEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static String getName(String code) {
        for (OpenEnventEnum c : OpenEnventEnum.values()) {
            if (c.getCode().equals(code)) {
                return c.description;
            }
        }
        return null;
    }

    private String code;
    private String description;

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
