package tech.glinfo.enbao.common.utils;

import com.baidu.aip.face.AipFace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 百度api工具类
 */
@ConfigurationProperties(prefix = "baidu")
@Component
public class BaiDuAPIUtils {
    private Logger logger = LoggerFactory.getLogger(getClass());

    private static String appId;
    private static String apiKey;
    private static String secretKey;

    public static AipFace getApiFace() {
        return ApiFaceUtils.instance;
    }

    private static class ApiFaceUtils {
        public final static AipFace instance = new AipFace(appId, apiKey, secretKey);
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getApiKey() {
        return apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }
}
