package tech.glinfo.enbao.modules.sh.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.annotation.Login;
import tech.glinfo.enbao.common.annotation.LoginUser;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.modules.appuser.entity.AppUserEntity;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceEntity;
import tech.glinfo.enbao.modules.sh.entity.ShFamilyRoomEntity;
import tech.glinfo.enbao.modules.sh.service.OtherShFamilyRoomService;

import java.util.Map;


@RestController
@RequestMapping("/shFamilyRoom")
@Api(value = "家庭房间")
public class ShFamilyRoomController {

    @Autowired
    private OtherShFamilyRoomService otherShFamilyRoomService;

    @Login
    @PostMapping("addOrUpdate")
    @ApiOperation("新增修改")
    @ApiLog("新增修改")
    public R addOrUpdate(@RequestBody Map<String, Object> params, @LoginUser AppUserEntity user) {
        return otherShFamilyRoomService.addOrUpdate(params, user);
    }

    @Login
    @GetMapping("roomManage/{id}")
    @ApiOperation("房间管理")
    @ApiLog("房间管理")
    public R roomManage(@PathVariable("id") Integer familyId) {
        return otherShFamilyRoomService.list(familyId);
    }

    @Login
    @GetMapping("indexList/{id}")
    @ApiOperation("房间管理")
    @ApiLog("房间管理")
    public R indexList(@PathVariable("id") Integer familyId) {
        return R.ok().put("data", otherShFamilyRoomService.list(new QueryWrapper<ShFamilyRoomEntity>().eq("family_id", familyId)));
    }


    @Login
    @GetMapping("info/{id}")
    @ApiOperation("详情")
    @ApiLog("详情")
    public R info(@PathVariable("id") Integer id) {
        return otherShFamilyRoomService.info(id);
    }

    @Login
    @PostMapping("delete")
    @ApiOperation("删除")
    @ApiLog("删除")
    public R delete(@RequestBody Map<String, Object> params) {

        return otherShFamilyRoomService.delete(params);
    }


    @Login
    @PostMapping("removeRelation")
    @ApiOperation("移除关联")
    @ApiLog("移除关联")
    public R removeRelation(@RequestBody Map<String, Object> params) {
        Integer deviceId  = (Integer) params.get("deviceId");
        return otherShFamilyRoomService.removeRelation(deviceId);
    }



}