package tech.glinfo.enbao.common.utils;

public enum TipsEnventEnum implements IEnventEnum{

    BELL("01", "门铃提醒事件"),
    LOW("02", "低电量提醒事件");

    TipsEnventEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static String getName(String code) {
        for (TipsEnventEnum c : TipsEnventEnum.values()) {
            if (c.getCode().equals(code)) {
                return c.description;
            }
        }
        return null;
    }

    private String code;
    private String description;

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
