package tech.glinfo.enbao.modules.appuser.service;

import com.baomidou.mybatisplus.extension.service.IService;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.modules.appuser.entity.AppUserEntity;
import tech.glinfo.enbao.modules.appuser.form.LoginForm;
import tech.glinfo.enbao.modules.appuser.form.QuickLoginForm;

import java.util.Map;
import java.util.Set;

/**
 * APP用户
 *
 * @author linzhenjie
 * @email linzhenjie@gltech.com
 * @date 2019-11-18 16:33:09
 */
public interface OtherAppUserService extends IService<AppUserEntity> {

    PageUtils queryPage(Map<String, Object> params);

    AppUserEntity queryByPhone(String mobile);

    /**
     * 用户登录
     * @param form    登录表单
     * @return        返回用户ID
     */
    AppUserEntity login(LoginForm form);

    /**
     * 快捷用户登录
     * @param form    登录表单
     * @return        返回用户ID
     */
    AppUserEntity quickLogin(QuickLoginForm form);

//    R updateStatus(Integer userId, String phone);

}

