package tech.glinfo.enbao.modules.sh.controller;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.contants.Constants;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.RedisUtils;
import tech.glinfo.enbao.modules.sh.entity.ShSpeakerFirstKeywordsEntity;
import tech.glinfo.enbao.modules.sh.service.ShSpeakerFirstKeywordsService;

import java.util.Arrays;
import java.util.List;
import java.util.Map;


/**
 * 智能音箱一级关键字
 *
 * @author linzhenjie
 * @email linzhenjie@gltech.com
 * @date 2021-06-29 15:57:11
 */
@RestController
@RequestMapping("sh/speakerfirstkeywords")
public class ShSpeakerFirstKeywordsController {
    @Autowired
    private ShSpeakerFirstKeywordsService shSpeakerFirstKeywordsService;

    @Autowired
    private RedisUtils redisUtils;

    /**
     * 列表
     */
    @RequestMapping("/list")
    @RequiresPermissions("sh:speakerfirstkeywords:list")
    public R list(@RequestParam Map<String, Object> params){
        PageUtils page = shSpeakerFirstKeywordsService.queryPage(params);

        return R.ok().put("page", page);
    }

    /**
     * 列表
     */
    @RequestMapping("/allList")
    @RequiresPermissions("sh:speakerfirstkeywords:list")
    public R allList(){
        List<ShSpeakerFirstKeywordsEntity> list = shSpeakerFirstKeywordsService.list();
        return R.ok().put("list", list);
    }


    /**
     * 信息
     */
    @RequestMapping("/info/{id}")
    @RequiresPermissions("sh:speakerfirstkeywords:info")
    public R info(@PathVariable("id") Integer id){
		ShSpeakerFirstKeywordsEntity speakerFirstKeywords = shSpeakerFirstKeywordsService.getById(id);

        return R.ok().put("speakerFirstKeywords", speakerFirstKeywords);
    }

    /**
     * 保存
     */
    @RequestMapping("/save")
    @RequiresPermissions("sh:speakerfirstkeywords:save")
    public R save(@RequestBody ShSpeakerFirstKeywordsEntity speakerFirstKeywords){
        shSpeakerFirstKeywordsService.save(speakerFirstKeywords);
        redisUtils.delete(Constants.DEVICE_KEYWORD_ONE);
        List<ShSpeakerFirstKeywordsEntity> list = shSpeakerFirstKeywordsService.list();
        if (list.size() > 0) {
            redisUtils.set(Constants.DEVICE_KEYWORD_ONE, list);
        }
        return R.ok();
    }

    /**
     * 修改
     */
    @RequestMapping("/update")
    @RequiresPermissions("sh:speakerfirstkeywords:update")
    public R update(@RequestBody ShSpeakerFirstKeywordsEntity speakerFirstKeywords){
        shSpeakerFirstKeywordsService.updateById(speakerFirstKeywords);
        redisUtils.delete(Constants.DEVICE_KEYWORD_ONE);
        List<ShSpeakerFirstKeywordsEntity> list = shSpeakerFirstKeywordsService.list();
        if (list.size() > 0) {
            redisUtils.set(Constants.DEVICE_KEYWORD_ONE, list);
        }
        return R.ok();
    }

    /**
     * 删除
     */
    @RequestMapping("/delete")
    @RequiresPermissions("sh:speakerfirstkeywords:delete")
    public R delete(@RequestBody Integer[] ids){
        shSpeakerFirstKeywordsService.removeByIds(Arrays.asList(ids));
        for (Integer id : ids) {
            //清除缓存
            redisUtils.deletes(Constants.DEVICE_KEYWORD_ONE + "-" + id);
        }
        redisUtils.delete(Constants.DEVICE_KEYWORD_ONE);
        List<ShSpeakerFirstKeywordsEntity> list = shSpeakerFirstKeywordsService.list();
        if (list.size() > 0) {
            redisUtils.set(Constants.DEVICE_KEYWORD_ONE, list);
        }
        return R.ok();
    }

}
