package tech.glinfo.enbao.modules.sh.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.modules.sh.entity.ShInstructionParsingEntity;
import tech.glinfo.enbao.modules.sh.service.ShInstructionParsingService;

import java.util.Arrays;
import java.util.List;
import java.util.Map;


/**
 * 指令解析
 *
 * @author linzhenjie
 * @email linzhenjie@gltech.com
 * @date 2020-02-14 14:06:08
 */
@RestController
@RequestMapping("sh/instructionparsing")
public class ShInstructionParsingController {
    @Autowired
    private ShInstructionParsingService shInstructionParsingService;

    /**
     * 列表
     */
    @RequestMapping("/list")
    @RequiresPermissions("sh:instructionparsing:list")
    public R list(@RequestParam Map<String, Object> params){
        PageUtils page = shInstructionParsingService.queryPage(params);

        return R.ok().put("page", page);
    }

    /**
     * 列表
     */
    @RequestMapping("/listAll")
//    @RequiresPermissions("oshare:instructionparsing:list")
    public R listAll(@RequestParam Map<String, Object> params){
        List<ShInstructionParsingEntity> page = shInstructionParsingService.list(new QueryWrapper<ShInstructionParsingEntity>().eq("product_id", params.get("productId")).orderByDesc("id"));

        return R.ok().put("page", page);
    }


    /**
     * 信息
     */
    @RequestMapping("/info/{id}")
    @RequiresPermissions("sh:instructionparsing:info")
    public R info(@PathVariable("id") Integer id){
        ShInstructionParsingEntity instructionParsing = shInstructionParsingService.getById(id);

        return R.ok().put("instructionParsing", instructionParsing);
    }

    /**
     * 保存
     */
    @RequestMapping("/save")
    @RequiresPermissions("sh:instructionparsing:save")
    public R save(@RequestBody ShInstructionParsingEntity instructionParsing){
        shInstructionParsingService.save(instructionParsing);

        return R.ok();
    }

    /**
     * 修改
     */
    @RequestMapping("/update")
    @RequiresPermissions("sh:instructionparsing:update")
    public R update(@RequestBody ShInstructionParsingEntity instructionParsing){
        shInstructionParsingService.updateById(instructionParsing);

        return R.ok();
    }

    /**
     * 删除
     */
    @RequestMapping("/delete")
    @RequiresPermissions("sh:instructionparsing:delete")
    public R delete(@RequestBody Integer[] ids){
        shInstructionParsingService.removeByIds(Arrays.asList(ids));

        return R.ok();
    }

}
