package tech.glinfo.enbao.modules.appuser.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * APP用户
 * 
 * @author linyetong
 * @email linyetong@glinfo.com
 * @date 2021-12-24 14:23:11
 */
@Data
@TableName("app_user")
public class AppUserEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 主键id
	 */
	@TableId
	private Integer id;
	/**
	 * 手机号码
	 */
	private String phone;
	/**
	 * 第三方ID
	 */
	private String thirdId;
	/**
	 * 微信openid
	 */
	private String openId;
	/**
	 * unionid
	 */
	private String unionId;
	/**
	 * 密码
	 */
	private String password;
	/**
	 * 昵称
	 */
	private String nickname;
	/**
	 * 头像
	 */
	private String headImgUrl;
	/**
	 * 状态[1正常;2禁用]
	 */
	private Integer status;
	/**
	 * 最后登录时间
	 */
	private Date lastLoginTime;
	/**
	 * 创建时间
	 */
	private Date createTime;

}
