package tech.glinfo.enbao.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;

public class StringUtils extends org.apache.commons.lang.StringUtils {

	private static Logger logger = LoggerFactory.getLogger(StringUtils.class);

	/**
	 * 判断对象是否为null
	 *
	 * @param objects
	 * @return
	 */
	public static boolean isNull(Object... objects) {
		for (Object object : objects) {
			if (object == null) {
				return true;
			}
		}
		return false;
	}

	public static String getNullParameterName(String[] params, Object... objects) {
		int index = 0;
		String parameterName = "";
		for (int i = 0; i < objects.length; i++) {
			if (objects[i] == null) {
				index = i;
			}
		}
		parameterName = params[index];
		return parameterName;
	}

	/**
	 * 判断对象是否为null或“”
	 *
	 * @param objects
	 * @return
	 */
	public static boolean isBlank(Object... objects) {
		for (Object object : objects) {
			if (object == null || "".equals(object)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * 格式化Bigdecimal，保留两位小数
	 *
	 * @param bd
	 * @return
	 */
	public static BigDecimal formatDecimal(BigDecimal bd) {
		DecimalFormat format = new DecimalFormat("##.000");
		if (bd == null)
			return new BigDecimal("0.000");
		return new BigDecimal(format.format(bd));
	}

	public static String removeEndZero(String number) {
		if (number == null)
			return "";
		if (number.indexOf(".") > 0) {
			// 正则表达
			number = number.replaceAll("0+?$", "");// 去掉后面无用的零
			number = number.replaceAll("[.]$", "");// 如小数点后面全是零则去掉小数点
		}
		return number;
	}

	public static String formatDecimalAndRemoveEndZero(BigDecimal bd) {
		DecimalFormat format = new DecimalFormat("##.00000");
		if (bd == null)
			return "0";
		String str = removeEndZero(new BigDecimal(format.format(bd))+"");
		return str;
	}

	/**
	 * 清理字符串，清理出某些不可见字符
	 * @param txt
	 * @return {String}
	 */
	public static String cleanChars(String txt) {
		return txt.replaceAll("[ 　	`·•�\\f\\t\\v]", "");
	}

	// 随机字符串
	private static final String _INT = "0123456789";
	private static final String _HEX = "0123456789ABCDEF";
	private static final String _STR = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
	private static final String _STR2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	private static final String _STR3 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	private static final String _ALL = _INT + _STR;

	private static final Random RANDOM = new Random();

	/**
	 * 生成的随机数类型
	 */
	public static enum RandomType {
		INT, HEX, STRING, ALL, STRING2, STRING3;
	}

	/**
	 * 随机数生成
	 * @param count
	 * @return
	 */
	public static String random(int count, RandomType randomType) {
		if (count == 0) return "";
		if (count < 0) {
			throw new IllegalArgumentException("Requested random string length " + count + " is less than 0.");
		}
		char[] buffer = new char[count];
		for (int i = 0; i < count; i++) {
			if (randomType.equals(RandomType.INT)) {
				buffer[i] = _INT.charAt(RANDOM.nextInt(_INT.length()));
			} else if (randomType.equals(RandomType.STRING)) {
				buffer[i] = _STR.charAt(RANDOM.nextInt(_STR.length()));
			} else if (randomType.equals(RandomType.HEX)) {
				buffer[i] = _HEX.charAt(RANDOM.nextInt(_HEX.length()));
			} else if (randomType.equals(RandomType.STRING2)) {
				buffer[i] = _STR2.charAt(RANDOM.nextInt(_STR2.length()));
			} else if (randomType.equals(RandomType.STRING3)) {
				buffer[i] = _STR3.charAt(RANDOM.nextInt(_STR3.length()));
			} else {
				buffer[i] = _ALL.charAt(RANDOM.nextInt(_ALL.length()));
			}
		}
		return new String(buffer);
	}

	/**
	 * 获取UUID，去掉`-`的
	 * @return uuid
	 */
	public static String getUUID () {
		return UUID.randomUUID().toString().replace("-", "");
	}

	/**
	 * 计算校验码返回
	 * @param cmd
	 * @return
	 */
	public static String rebackInfor(String cmd) {
		String backinfor = cmd;
		char[] ba = backinfor.toCharArray();
		char[] ch = new char[backinfor.length()];
		String two;
		for (int i = 0; i < backinfor.length(); i = i + 2) {
			two = backinfor.substring(i, i + 2);
//            System.out.println("two:" + two);
			ch[i / 2] = StringToUnchar(two);
		}
		int number = 0;
		for (int i = 0; i < backinfor.length(); i++)//前38个字节算数和
		{
			number = ch[i] + number;
		}
		int sum_hear = number % 256;
		sum_hear = 255 - sum_hear;
		String flag = Integer.toHexString(sum_hear).toUpperCase();
//        System.out.println("flag:" + flag);
		if (flag.length() == 0) {
			flag = "00";
		}
		if (flag.length() == 1) {
			flag = "0" + flag;
		}
		backinfor = backinfor + flag;
		return backinfor;
	}

	private static Character StringToUnchar(String sendstring) {
		if (sendstring.length() == 2) {
			char temp = sendstring.charAt(0);
			char temp1 = sendstring.charAt(1);
			if (temp >= '0' && temp <= '9') {
				temp &= 0x0f;
			}
			if (temp >= 'a' && temp <= 'f') {
				temp &= 0x0f;
				temp += 0x09;
			}
			if (temp >= 'A' && temp <= 'F') {
				temp &= 0x0f;
				temp += 0x09;
			}
			temp <<= 4;

			if (temp1 >= '0' && temp1 <= '9') {
				temp1 &= 0x0f;
			}
			if (temp1 >= 'a' && temp1 <= 'f') {
				temp1 &= 0x0f;
				temp1 += 0x09;
			}
			if (temp1 >= 'A' && temp1 <= 'F') {
				temp1 &= 0x0f;
				temp1 += 0x09;
			}
//            int t1 = Integer.parseInt(temp + "", 16);
//            int t2 = Integer.parseInt(temp1 + "", 16);
//            System.out.println(temp+temp1);
			char ok = (char) (temp + temp1);
//            System.out.println(String.valueOf(ok));
			return ok;
		}
		return null;
	}

	/**
	 *
	 * @param str     原字符串
	 * @param length  补值后字符串长度
	 * @param isHead  true-前面补值，false-后面补值
	 * @param character  补充的字符
	 * @return
	 */
	public static String appendString(String str, int length, boolean isHead, String character) {
		if (character == null || character.length() != 1) {
			return null;
		}
		if (str == null) {
			return null;
		} else if (str.length() >= length) {
			return str;
		} else {
			int charLength = length - str.length();
			if (isHead) {
				StringBuilder builder = new StringBuilder();
				for (int i = 0; i < charLength; i++) {
					builder.append(character);
				}
				builder.append(str);
				return builder.toString();
			} else {
				StringBuilder builder = new StringBuilder(str);
				for (int i = 0; i < charLength; i++) {
					builder.append(character);
				}
				return builder.toString();
			}
		}
	}

	public static int getIntFStr(String b) {
		return Integer.parseInt(b, 2);
	}

	/**
	 * 获取红外遥控代码
	 * @param A 认别码 A=10110010=B2
	 * @param B 风速
	 * @param C 温度模式
	 * @param off 是否为关机
	 * @return
	 */
	public static List<Integer> getCode(int A, int B, int C, boolean off){
		List<Integer> list = new ArrayList<>();
		int mask=0x80;
		int cnt=2;
		list.add(4400);
		list.add(4400);
		//发A
		for(mask=0x80;mask!=0;mask>>=1){
			list.add(550);
//            System.out.println(Integer.toBinaryString(mask));
//            System.out.println(mask & A);
			if((mask & A) > 0) {
				list.add(1660);
			} else {
				list.add(550);
			}
		}
		for(mask=0x80;mask!=0;mask>>=1){
			list.add(550);
			if((mask & (~A))  > 0) {
				list.add(1660);
			} else {
				list.add(550);
			}
		}
		//发B
		for(mask=0x80;mask!=0;mask>>=1){
			list.add(550);
			if((mask & B)  > 0) {
				list.add(1660);
			} else {
				list.add(550);
			}
		}
		for(mask=0x80;mask!=0;mask>>=1){
			list.add(550);
			if((mask & (~B))  > 0) {
				list.add(1660);
			} else {
				list.add(550);
			}
		}
		//发C
		for(mask=0x80;mask!=0;mask>>=1){
			list.add(550);
			if((mask & C)  > 0) {
				list.add(1660);
			} else {
				list.add(550);
			}
		}
		for(mask=0x80;mask!=0;mask>>=1){
			list.add(550);
			if((mask & (~C))  > 0) {
				list.add(1660);
			} else {
				list.add(550);
			}
		}

		list.add(550);
		list.add(5220);
		list.add(4400);
		list.add(4400);

		//发A
		for(mask=0x80;mask!=0;mask>>=1){
			list.add(550);
			if((mask & A)  > 0) {
				list.add(1660);
			} else {
				list.add(550);
			}
		}
		for(mask=0x80;mask!=0;mask>>=1){
			list.add(550);
			if((mask & (~A))  > 0) {
				list.add(1660);
			} else {
				list.add(550);
			}
		}
		//发B
		for(mask=0x80;mask!=0;mask>>=1){
			list.add(550);
			if((mask & B)  > 0) {
				list.add(1660);
			} else {
				list.add(550);
			}
		}
		for(mask=0x80;mask!=0;mask>>=1){
			list.add(550);
			if((mask & (~B))  > 0) {
				list.add(1660);
			} else {
				list.add(550);
			}
		}
		//发C
		for(mask=0x80;mask!=0;mask>>=1){
			list.add(550);
			if((mask & C)  > 0) {
				list.add(1660);
			} else {
				list.add(550);
			}
		}
		for(mask=0x80;mask!=0;mask>>=1){
			list.add(550);
			if((mask & (~C))  > 0) {
				list.add(1660);
			} else {
				list.add(550);
			}
		}

		if(off) {
			list.add(550);
			list.add(5220);
			list.add(4400);
			list.add(4400);
			//发A
			for(mask=0x80;mask!=0;mask>>=1){
				list.add(550);
				if((mask & A)  > 0) {
					list.add(1660);
				} else {
					list.add(550);
				}
			}
			for(mask=0x80;mask!=0;mask>>=1){
				list.add(550);
				if((mask & (~A))  > 0) {
					list.add(1660);
				} else {
					list.add(550);
				}
			}
			//发Q
			int Q = 0, Y = 0;
			for(mask=0x80;mask!=0;mask>>=1){
				list.add(550);
				if((mask & Q)  > 0) {
					list.add(1660);
				} else {
					list.add(550);
				}
			}
			for(mask=0x80;mask!=0;mask>>=1){
				list.add(550);
				if((mask & (~Q))  > 0) {
					list.add(1660);
				} else {
					list.add(550);
				}
			}
			//发Y
			for(mask=0x80;mask!=0;mask>>=1){
				list.add(550);
				if((mask & Y)  > 0) {
					list.add(1660);
				} else {
					list.add(550);
				}
			}
			for(mask=0x80;mask!=0;mask>>=1){
				list.add(550);
				if((mask & (~Y))  > 0) {
					list.add(1660);
				} else {
					list.add(550);
				}
			}
		}

		list.add(550);
		list.add(8000);

		return list;

	}

	public static void main(String[] args) {
		long l = System.currentTimeMillis();
		Set<String> sets = new HashSet<>();
		for(int i=0; i<100000; i++) {
			String random = null;
			do{
				random = random(14, RandomType.STRING3);
			} while (sets.contains(random));

			sets.add(random);
		}
		System.out.println(System.currentTimeMillis()-l);
		/*for(String s : sets) {
			System.out.println(s);
		}*/
	}

}
